# -*- Mode: python; coding: utf-8; tab-width: 8; indent-tabs-mode: t; -*-
#
# Copyright (C) 2007 Sirio Bolaños Puchet
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.

import urllib
import re
import rb

class LyricsmaniaParser (object):
	def __init__(self, artist, title):
		self.artist = artist
		self.title = title

	def search(self, callback, *data):
		wartist = re.sub('%20', '+', urllib.quote(self.artist))

		wurl = 'http://www.lyricsmania.com/search.php?k=%s&c=artist' % wartist

		loader = rb.Loader()
		loader.get_url (wurl, self.got_results, callback, *data)

	def got_results (self, result, callback, *data):
		if result is None:
			callback (None, *data)
			return

		if re.search('No results for your search',result) is None:

			if re.search('artists found:',result) is not None:

				result = re.sub('\n','',result)
				artist_matches = re.split('artists found:<br><br>',result)[1]
				artist_matches = re.split('</td><td width=50% valign=top><br>',artist_matches)[0]
				artist_matches = re.split('</a></h1><br>',artist_matches)
				artist_matches.pop()
				artist_matches_ids = [re.split('/" title',re.split('_lyrics_',match)[1])[0] for match in artist_matches]
				artist_matches = [re.split('lyrics">',match.lower())[1] for match in artist_matches]
				try:
					artist_match_id = artist_matches.index(self.artist.lower())
					artist_id = artist_matches_ids[artist_match_id]
					artist_url = 'http://www.lyricsmania.com' + '/lyrics/' + self.artist.lower() + '_lyrics_' + artist_id + '/all.html'

					loader = rb.Loader()
					loader.get_url (artist_url, self.parse_songs, callback, *data)

				except:
					callback (None, *data)
					return

			elif re.search(self.artist,result,re.I):

				body = re.split('lyrics</h3>',result)[1]
				body = re.split('<b>Top Artists</b><br><br>',body)[0]

				matches = re.findall(">"+self.title+"<",body,re.I)

				if matches:
					match = matches[0]
					song = match[1:-1]
					line = re.split('>' + song + '</a>',body)[0]
					line = re.split("</a><br>",line)[-1]
					url = re.split('.html\"',line)[-2]
					sid = re.split('_lyrics_',url)[-1]

					wurl = 'http://www.lyricsmania.com/print/%s.html' % sid

					loader = rb.Loader()
					loader.get_url (wurl, self.parse_lyrics, callback, *data)
					return
				else:
					callback (None, *data)
					return
			else:
				callback (None, *data)
				return
		else:
			callback (None, *data)
			return

	def parse_songs(self, result, callback, *data):
		if result is None:
			callback (None, *data)
			return

		song_matches = re.sub('\n','',result)
		song_matches = re.split('Alphabetical songs order<br><br>',song_matches)[1]
		song_matches = re.split('</td><td width=50% valign=top>',song_matches)[0]
		song_matches = re.split('</a><br>',song_matches)
		song_matches.pop()
		title_matches = [re.split('lyrics">',match.lower())[1] for match in song_matches]
		title_matches_ids = [re.split('.html',re.split('_lyrics_',match)[3])[0] for match in song_matches]
		try :
			title_match_id = title_matches.index(self.title.lower())
			title_id = title_matches_ids[title_match_id]

			title_url = 'http://www.lyricsmania.com' + '/print/' + title_id + '.html'

			loader = rb.Loader()
			loader.get_url (title_url, self.parse_lyrics, callback, *data)
			return

		except:
			callback (None, *data)
			return

	def parse_lyrics(self, result, callback, *data):
		if result is None:
			callback (None, *data)
			return

		result = re.sub('\r', '\n', result)
		result = result.decode("iso-8859-1")

		artist = re.split('<font face=verdana size=2><b>',result)[1]
		artist = re.split('</b></font><br>',artist)[0]

		title = re.split('<font face=verdana size=3><b>',result)[1]
		title = re.split('</b></font><br><br>',title)[0]

		title = "%s - %s\n\n" % (artist, title)

		lyric = re.split('<font face=verdana size=2 title="www.lyricsmania.com">',result)[1]
		lyric = re.split('</font>\n</div>\n</center>',lyric)[0]
		lyric = re.sub('<[uU]>.*?<\/[uU]>','',lyric)

		lyrics = title + lyric

		callback (lyrics, *data)

