# -*- Mode: python; coding: utf-8; tab-width: 8; indent-tabs-mode: t; -*-
#
# Copyright (C) 2007 Sirio Bolaños Puchet
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.

import urllib
import re
import rb

class MLDbParser (object):
	def __init__(self, artist, title):
		self.artist = artist
		self.title = title

	def search(self, callback, *data):

		query = self.artist.lower() + ' ' + self.title.lower()
		query = re.sub('%20','+',urllib.quote(query))

		wurl = 'http://www.mldb.org/search?mq=%s&si=0&mm=0&ob=1' % query

		loader = rb.Loader()
		loader.get_url (wurl, self.parse_lyrics, callback, *data)
		return

	def parse_lyrics(self, result, callback, *data):
		if result is None:
			callback (None, *data)
			return

		if re.search('did not match any documents.',result) is None:
			result = re.sub('\r','',re.sub('\n','',result))
			lyric = re.split('<p class=songtext>',result)[1]
			lyric = re.split('<BR><BR></td></tr>',lyric)[0]
			lyric = re.sub('<br />','\n',lyric)
			lyric += "\n\nLyrics provided by MLDb.org"

			title = self.artist + " - " + self.title + "\n\n"

			lyrics = title + lyric

			callback (lyrics, *data)
		else:
			callback (None, *data)
			return
