import rb, rhythmdb
import os
import pwd
import popen2
import time
import string
import random
random.seed()

class LogitechG15Plugin(rb.Plugin):
	def __init__(self):
		rb.Plugin.__init__(self)
	def activate(self, shell):

			# Open the LCD Fifo
			#username = pwd.getpwuid(os.getuid())[0]
			#self.fifo_filename = os.environ.get('HOME') + '/.g15fifo-' + username
			#self.encoding = 'latin-1'
			#self.LCDFifo = os.open(self.fifo_filename, os.O_WRONLY)
			#if not(self.LCDFifo):
			#	print "Failed to open FIFO '%s'" % self.fifo_filename
			# 	return
			# Display that the plugin was initialized
			#Creates a new FIFO with a random name in the /tmp directory
			self.FIFOname=GetRandomName('RBtoG15-')
			self.FIFOpath='/tmp/'+self.FIFOname
			try:
				os.mkfifo(self.FIFOpath)
			except:
				raise Exception, "Failed to create a FIFO in the /tmp directory."
				
			#Starts a new g15composer instance
			try:
				self.Child=popen2.Popen4('g15composer '+self.FIFOpath)
			except:
				raise Exception, "Failed to start g15composer. Make sure is installed and available"
			self.PID=self.Child.pid
			time.sleep(0.1)
			
			self.encoding = 'latin-1'
			self.LCDFifo = os.open(self.FIFOpath, os.O_WRONLY)
			if not(self.LCDFifo):
				raise Exception, "Failed to open FIFO '%s'" % self.FIFOpath
			self.Active=True
			
			# register the playing-song-changed method
			self.shell = shell
			self.player = shell.get_player()
			self.pec_id = self.player.connect('playing-changed', self.playing_changed)
			self.pch_id = self.player.connect('playing-song-changed', self.playing_entry_changed)
			self.timup_id = self.player.connect('elapsed-changed', self.timer_update)
			self.infoch_id = self.player.connect('playing-song-property-changed', self.tag_changed)
			self.playing_entry_changed(self.player, self.player.get_playing_entry())
			# Finish
			print "G15 was initialized successfully"

	def deactivate(self, shell):
		self.Active=False
		shell.disconnect(self.pec_id)
		shell.disconnect(self.pch_id)
		shell.disconnect(self.timup_id)
		shell.disconnect(self.infoch_id)
		os.kill(self.PID+1, 9)
		if(self.LCDFifo):
			os.close(self.LCDFifo)
		os.remove(self.FIFOpath)
		del self.shell
			
	def playing_changed(self, player, entry):
		if not player.get_playing_entry(): return
		data=[]
		if player.get_playing():
			msg='PO 140 13 18 18 "'
			for y in range(0,18):
				for x in range(0,18):
					if x<=y*2 and x<=(18-y)*2:
						msg=msg+'1'
					else:
						msg=msg+'0'
			data.append(msg+'"')
		else:
			data.append('PB 140 13 158 31 0 1 1')
			data.append('PB 140 13 145 30 1 1 1')
			data.append('PB 150 13 155 30 1 1 1')
		self.SendLCD(data)
		
	def tag_changed(self, player, b, c, d, e):
		self.playing_entry_changed(player, b, update=True)

	def playing_entry_changed(self, player, entry, update=False):
#		try:
			data=[]
			entry=player.get_playing_entry()
			if entry is not None:
				
				#Clear the LCD where i'm going to put data.
				data.append('PB 0 0 200 12 0 1 1') 
				data.append('PB 0 0 139 34 0 1 1')
				
				#Get song data
				db = self.shell.get_property("db")
				artist = db.entry_get(entry, rhythmdb.PROP_ARTIST)
				album = db.entry_get(entry, rhythmdb.PROP_ALBUM)
				title = db.entry_get(entry, rhythmdb.PROP_TITLE)
				genre = db.entry_get(entry, rhythmdb.PROP_GENRE)
				total_time=player.get_playing_song_duration()
				artist=FixStrLen(artist,25)
				album=FixStrLen(album,25)
				genre=FixStrLen(genre,25)
				
				#Set title
				if len(title)<20:
					title_entry=u'TO 1 1 2 1 "%s"' % (title)
				elif len(title)<32:
					title_entry=u'TO 1 1 1 1 "%s"' % (title)
				else:
					title_entry=u'TO 1 1 0 1 "%s"' % (FixStrLen(title,40))
				data.append(title_entry.encode(self.encoding))	
				
				#Set artist-album-genre
				gen_data = u'TO 1 13 0 0 "Artist: %s" "Album:  %s" "Genre:  %s"' % (artist, album, genre)
				data.append(gen_data.encode(self.encoding))
				
				#updates the song timer
				self.timer_update(player,entry)
			else:
				self.clear_LCD()
				data.append('TO 1 10 2 1 "RhythmBox V%s"' % (str(rb.__version__)))
				data.append('TO 1 30 1 1 "Stopped"')
			self.SendLCD(data)
#		except Exception, err:
#			print "Failed to update LCD on changed entry: %s" % err 
	
	def timer_update(self,player,entry):
		if entry:
			total_time=player.get_playing_song_duration()
			try:
				played_time=player.get_playing_time()
			except:
				played_time=0
			self.SendLCD(self.GetPlayedBar(played_time,total_time))
			
	def GetPlayedBar(self,cur,tot):
		cur_text=self.GetTimeStr(cur)
		tot_text=self.GetTimeStr(tot)
		data=[]
		data.append('TO 1 36 0 0 "%s  "' % (cur_text))
		data.append('TO 138 36 0 0 "%s  "' % (tot_text))
		if cur:
			data.append('DB 22 35 135 42 1 %s %s 2' % (str(cur), str(tot)))
		else:
			data.append('PB 23 36 134 41 0 1 1')
			data.append('PB 22 35 135 42 1')
		return data
	
	def GetTimeStr(self,num):
		min_str=str(num/60)
		sec_str=str(num%60)
		if len(sec_str)==1: sec_str='0'+sec_str
		return  min_str +':' + sec_str
		
	def SendLCD(self,lines):
		if not self.Active: return
		txt=''
		for L in lines:
			txt=txt+L+'\n'
		os.write(self.LCDFifo, txt)

	def clear_LCD(self):
		self.SendLCD(['PC 0'])
		
def FixStrLen(str,max):
	if len(str)>max:
		return str[:max-3]+'...'
	else:
		return str
		
def GetRandomName(prefix):
	domain=string.letters+string.digits
	name=''
	for i in range(8): name=name+domain[random.randint(0,len(domain)-1)]
	return prefix+name
