package Price;

use strict;
use warnings;

use Rose::DB::Object;
our @ISA = qw(Rose::DB::Object);

__PACKAGE__->meta->table('prices');

__PACKAGE__->meta->columns
    (
     id         => { type => 'int', primary_key => 1 },
     price      => { type => 'decimal' },
     region     => { type => 'char', length => 3 },
     product_id => { type => 'int' }
    );

__PACKAGE__->meta->add_unique_key('product_id', 'region');

__PACKAGE__->meta->initialize;


1;
