package Product;

use strict;
use warnings;

use Rose::DB::Object;
our @ISA = qw(Rose::DB::Object);

__PACKAGE__->meta->table('products');

__PACKAGE__->meta->columns
    (
     id          => { type => 'int', primary_key => 1 },
     name        => { type => 'varchar', length => 255 },
     description => { type => 'text' },
     category_id => { type => 'int' },

     status =>
     {
      type      => 'varchar', 
      check_in  => [ 'active', 'inactive' ],
      default   => 'inactive',
     },

     start_date  => { type => 'datetime' },
     end_date    => { type => 'datetime' },

     date_created     => { type => 'timestamp', default => 'now' },
     last_modified    => { type => 'timestamp', default => 'now' },
    );

__PACKAGE__->meta->add_unique_key('name');

__PACKAGE__->meta->foreign_keys
    (
     category =>
     {
      class       => 'Category',
      key_columns =>
      {
       category_id => 'id',
      }
     },
    );

# This part cannot be done automatically.
# perldoc Rose::DB::Object::Metadata to find out why.
__PACKAGE__->meta->relationships
    (
     prices =>
     {
      type       => 'one to many',
      class      => 'Price',
      column_map => { id => 'product_id' },
     },
    );

__PACKAGE__->meta->initialize;


1;
