#!/usr/bin/perl -w

use strict;

use lib '/home/uwe/tmp/cvs/rose/modules/Rose-DB/lib';
use Rose::DB;
use lib '/home/uwe/tmp/cvs/rose/modules/Rose-DB-Object/lib';
use Rose::DB::Object::Manager;

BEGIN {
    Rose::DB->register_db(domain   => 'default',
                          type     => 'default',
                          driver   => 'mysql',
                          database => 'Rose',
                          username => 'uwe',
                          password => 'uwe',
                         );
}

use lib './lib';
use Category;
use Price;
use Product;


my %query = (
             #'Price.name'    => 'a',
            );
my %rose  = (object_class    => 'Product',
             require_objects => [qw(prices)],
             with_objects    => [],
             clauses         => [],
             query           => [%query],
            );

my $count    = Rose::DB::Object::Manager->get_objects_count(%rose);

printf("COUNT: %d\n\n", $count);

my $products = Rose::DB::Object::Manager->get_objects(%rose);

foreach my $product (@$products) {
    printf("ID:    %d\n", $product->id);
    printf("NAME:  %s\n", $product->name);
    print "\n";
}
