DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `description` text NOT NULL,
  PRIMARY KEY  (`id`)
);

DROP TABLE IF EXISTS `prices`;
CREATE TABLE `prices` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `price` decimal(10,0) NOT NULL default '0',
  `region` char(3) NOT NULL default '',
  `product_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
);

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `description` text NOT NULL,
  `category_id` int(10) unsigned NOT NULL default '0',
  `status` enum('active','inactive') NOT NULL default 'inactive',
  `start_date` date NOT NULL default '0000-00-00',
  `end_date` date NOT NULL default '0000-00-00',
  `date_created` timestamp(14) NOT NULL,
  `last_modified` timestamp(14) NOT NULL default '00000000000000',
  PRIMARY KEY  (`id`)
);
