package t::Product;
use strict;
use t::DBConn;
use base 'Rose::DB::Object';

sub init_db { return t::DBConn->new; }
__PACKAGE__->meta->auto_initialize;
__PACKAGE__->meta->relationships(
           product_details => {
                  type  => 'one to many',
                  class => 't::ProductDetail',
                  column_map => { id => 'product_id' },
           }
);

warn __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

foreach my $rel (t::Product->meta->relationships) {
      warn "RelationShip : " , $rel->name, ': ', $rel->type, "\n"; 
}

1;
__END__
