#!/usr/bin/perl
use strict;
use warnings;
use t::ProductDetail;
use t::Product;
use Test::More qw(no_plan);
use Test::Exception;

my $o_prod = t::Product->new;
ok($o_prod, 'empty Product created');
lives_ok { $o_prod->product_rating('excellent') } 'rating set';
lives_ok {
        $o_prod->product_details(
                    { product_name => 'vegetable' }
        )
} 'details survive';

lives_ok { $o_prod->save } 'saved';

__END__
