#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <rtems.h>
#include <rtems/extension.h>


//! The (POSIX API) application entry point
void *init(void *args);

void fatal_extension(Internal_errors_Source the_source,
                     bool                   is_internal,
                     Internal_errors_t      the_error);

#define CONFIGURE_INITIAL_EXTENSIONS { .fatal = fatal_extension }

#define CONFIGURE_POSIX_INIT_THREAD_TABLE
#define CONFIGURE_POSIX_INIT_THREAD_ENTRY_POINT init

#define CONFIGURE_APPLICATION_NEEDS_CLOCK_DRIVER
#define CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER

#define CONFIGURE_MAXIMUM_POSIX_THREADS 1

#define CONFIGURE_USE_IMFS_AS_BASE_FILESYSTEM

#define CONFIGURE_LIBIO_MAXIMUM_FILE_DESCRIPTORS 20


#define CONFIGURE_INIT
#include <rtems/confdefs.h>


#include <rtems/error.h>

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>

#include "fs_tar.h"


static const char *test_file_path = "/test";


void *init(void *args)
{
	int     test_file_fd;
	char    read_byte;
	ssize_t read_bytes;


	printf("Starting\n");
	fflush(stdout);


	if (rtems_tarfs_load("/", (uint8_t *) fs_tar, fs_tar_size) != 0)
		rtems_error(RTEMS_ERROR_PANIC, "%s:%u: %s(): Failed to extract file-system tar", __FILE__, __LINE__, __func__);


	if ((test_file_fd = open(test_file_path, O_RDONLY)) == -1)
		rtems_error(RTEMS_ERROR_PANIC, "%s:%u: %s(): Failed to open \"%s\". Error: \"%s\"", __FILE__, __LINE__, __func__, test_file_path, strerror(errno));

	if (lseek(test_file_fd, 1, SEEK_SET) == -1)
		rtems_error(RTEMS_ERROR_PANIC, "%s:%u: %s(): Failed to seek in \"%s\". Error: \"%s\"", __FILE__, __LINE__, __func__, test_file_path, strerror(errno));

	if ((read_bytes = read(test_file_fd, &read_byte, sizeof (read_byte))) != sizeof (read_byte))
		rtems_error(0, "%s:%u: %s(): Failed to read from \"%s\". Error: \"%s\"", __FILE__, __LINE__, __func__, test_file_path, (read_bytes == 0) ? "End of file" : strerror(errno));


	printf("Finished successfully!\n");
	fflush(stdout);

	// Perma-wedge
	while (1)
		;
}


void fatal_extension(Internal_errors_Source the_source,
                     bool                   is_internal,
                     Internal_errors_t      the_error)
{
	fflush(stdout);

	printk("%s:%u: %s(): Fatal %sinternal error: Source: %u, error: %u\n", __FILE__, __LINE__, __func__, is_internal ? "" : "non-", the_source, the_error);


	printk("Resetting...\n\n");
	fflush(stdout);
}
