#include "flashlib.h"
#include <malloc.h>
#include <string.h>
//#include <cpu_def.h>

int flashrelloc_check_id(const flash_alg_info_t *alg, flash_addr_t addr, int retid[2])
{
  unsigned long flags;
  int ret;
  fiq_save_and_cli(flags);
  ret=(alg+1)->check_id(alg+1, addr, retid);
  restore_flags(flags);
  return ret;
}

int flashrelloc_prog(const flash_alg_info_t *alg, flash_addr_t addr, const void *data, long count)
{
  unsigned long flags;
  int ret;
  fiq_save_and_cli(flags);
  ret=(alg+1)->prog(alg+1, addr, data, count);
  restore_flags(flags);
  return ret;
}

int flashrelloc_erase(const flash_alg_info_t *alg, flash_addr_t addr, long size)
{
  unsigned long flags;
  int ret;
  fiq_save_and_cli(flags);
  ret=(alg+1)->erase(alg+1, addr, size);
  restore_flags(flags);
  return ret;
}

int flashrelloc_lockctrl(const flash_alg_info_t *alg, flash_addr_t addr, long size, int lock)
{
  unsigned long flags;
  int ret;
  fiq_save_and_cli(flags);
  ret=(alg+1)->lockctrl(alg+1, addr, size, lock);
  restore_flags(flags);
  return ret;
}

int flashrelloc_getinfo(const struct flash_alg_info *alg, flash_addr_t addr, int what, unsigned long *infobuf)
{
  unsigned long flags;
  int ret;
  fiq_save_and_cli(flags);
  ret=(alg+1)->getinfo(alg+1, addr, what, infobuf);
  restore_flags(flags);
  return ret;
}

flash_alg_info_t *flash_alg_rellocate(const flash_alg_info_t *orig_alg)
{
  flash_alg_info_t *alg;
  flash_addr_t fnc_base;
  flash_addr_t fnc_size;
  unsigned long offs;
  
  alg=malloc(2*sizeof(flash_alg_info_t));
  if(alg==NULL)
    return NULL;

  memcpy(alg,   orig_alg, sizeof(flash_alg_info_t));
  memcpy(alg+1, orig_alg, sizeof(flash_alg_info_t));
  
  fnc_size=2048;
  
  alg->context=malloc(fnc_size);
  if(alg->context==NULL){
    free(alg);
    return NULL;
  }
  alg->check_id=flashrelloc_check_id;
  alg->prog=flashrelloc_prog;
  alg->erase=flashrelloc_erase;
  /* Could be disabled for security reasons */
 #if 1
  if((alg+1)->lockctrl != NULL)
    alg->lockctrl=flashrelloc_lockctrl;
 #endif
  if((alg+1)->getinfo != NULL)
    alg->getinfo=flashrelloc_getinfo;

  fnc_base=(flash_addr_t)orig_alg->check_id;
  if(fnc_base>(flash_addr_t)orig_alg->prog)
    fnc_base=(flash_addr_t)orig_alg->prog;
  if(fnc_base>(flash_addr_t)orig_alg->erase)
    fnc_base=(flash_addr_t)orig_alg->erase;
  
  fnc_base&=~0x1f;
  if(fnc_base>0) fnc_base-=0x20;
  
  memcpy(alg->context,(void*)fnc_base,fnc_size);
  offs=(flash_addr_t)alg->context-fnc_base;
  
  (alg+1)->check_id=(void*)((flash_addr_t)(alg+1)->check_id+offs);
  (alg+1)->prog=(void*)((flash_addr_t)(alg+1)->prog+offs);
  (alg+1)->erase=(void*)((flash_addr_t)(alg+1)->erase+offs);
  if((alg+1)->lockctrl != NULL)
    (alg+1)->lockctrl=(void*)((flash_addr_t)(alg+1)->lockctrl+offs);
  if((alg+1)->getinfo != NULL)
    (alg+1)->getinfo=(void*)((flash_addr_t)(alg+1)->getinfo+offs);

  return alg;
}


