#include "flashlib.h"
#include "strataflash.h"

#include "flashlib_local_config.h"

extern char __flash_base;
extern char __flash_size;

flash_alg_info_t flash_alg_default_data={
	.check_id=strataflash_check_id_x16,
	.prog=strataflash_prog_x16,
	.erase=strataflash_erase_x16,
	.lockctrl=strataflash_lockctrl_x16,
	.getinfo=strataflash_getinfo_x16,

	.start=(flash_addr_t)&__flash_base,
	.size=(flash_addr_t)&__flash_size,
	.sec_size=FLASH_BLOCK_SIZE, /*0x20000*/

#if defined(CONFIG_BOARD_mx_cpu4)
	.bb_sec_size=FLASH_BB_BLOCK_SIZE,
	.bb_sec_cnt=FLASH_BLOCK_SIZE/FLASH_BB_BLOCK_SIZE,
#else /*CONFIG_BOARD_mx_cpu1*/
	.bb_sec_size=0,
	.bb_sec_cnt=0,
#endif /*CONFIG_BOARD_mx_cpu1*/
};

flash_alg_info_t *flash_alg_default=&flash_alg_default_data;
