#ifndef _FLASHLIB_H
 #define _FLASHLIB_H

#include <stdint.h>
#include <endian.h>

/* native order can be specified only, 
 * if target supports misaligned operations 
 */
//#define WITH_FLASH_NATIVE_ORDER

//#define WITH_TARGET_BUS32

#ifdef WITH_FLASH_NATIVE_ORDER
  #define FLASH_BYTE_ORDER __BYTE_ORDER
#else /*WITH_FLASH_NATIVE_ORDER*/
  #define FLASH_BYTE_ORDER __BYTE_ORDER
#endif /*WITH_FLASH_NATIVE_ORDER*/


#if 1
  #define FLASH_WR32(adr,val) (*(volatile uint32_t*)(adr)=(val))
  #define FLASH_RD32(adr) (*(volatile uint32_t*)(adr))
  #define FLASH_WR16(adr,val) (*(volatile uint16_t*)(adr)=(val))
  #define FLASH_RD16(adr) (*(volatile uint16_t*)(adr))
  #define FLASH_WR8(adr,val) (*(volatile uint8_t*)(adr)=(val))
  #define FLASH_RD8(adr) (*(volatile uint8_t*)(adr))
#endif

typedef uint32_t flash_addr_t;

typedef struct flash_alg_info {
	/* Sets retid to manufacturer and type ID, returns <0 in case of error */
	int (*check_id)(const struct flash_alg_info *alg, flash_addr_t addr, int retid[2]);
	/* Programs one location of flash (16 bits for width=1 or 2; 8 bits for width8=0) */
	int (*prog)(const struct flash_alg_info *alg, flash_addr_t addr, const void *data, long count);
	/* Erase all sectors overlaped by region from addr of size bytes, size=0 => erase all */
	/* This version is capable only of full erase (size=0) and one sector (size=1) */
	int (*erase)(const struct flash_alg_info *alg, flash_addr_t addr, long size);
	int (*lockctrl)(const struct flash_alg_info *alg, flash_addr_t addr, long size, int lock);
	int (*getinfo)(const struct flash_alg_info *alg, flash_addr_t addr, int what, unsigned long *infobuf);

	void *context;

	flash_addr_t start;
	flash_addr_t size;
	flash_addr_t sec_size;

	flash_addr_t bb_sec_size;
	int32_t      bb_sec_cnt;

} flash_alg_info_t;


#define FLASH_INFO_MANUFACTURE_CODE   0
#define FLASH_INFO_DEVICE_CODE        1
#define FLASH_INFO_BLOCK_LOCK_STATE   2
#define FLASH_INFO_CFI_SIZE_LOG2      0x27
#define FLASH_INFO_CFI_ERBLK_REGIONS  0x2C
#define FLASH_INFO_CFI_REGN_BLKCNT(n) (0x2D+(n)*4)

int strataflash_check_id_x16(const flash_alg_info_t *alg, flash_addr_t addr, int retid[2]);
int strataflash_prog_x16(const flash_alg_info_t *alg, flash_addr_t addr, const void *data, long count);
int strataflash_erase_x16(const flash_alg_info_t *alg, flash_addr_t addr, long size);
int strataflash_lockctrl_x16(const struct flash_alg_info *alg, flash_addr_t addr, long size, int lock);
int strataflash_getinfo_x16(const struct flash_alg_info *alg, flash_addr_t addr, int what, unsigned long *infobuf);

flash_alg_info_t *flash_alg_rellocate(const flash_alg_info_t *orig_alg);

extern flash_alg_info_t *flash_alg_default;
extern flash_alg_info_t *flash_alg_bad;

#endif /*_FLASHLIB_H*/
