#ifndef _FLASHLIB_H
 #define _FLASHLIB_H

#include <inttypes.h>
#include <endian.h>

/* native order can be specified only, 
 * if target supports misaligned operations 
 */
//#define WITH_FLASH_NATIVE_ORDER

//#define WITH_TARGET_BUS32

#ifdef WITH_FLASH_NATIVE_ORDER
  #define FLASH_BYTE_ORDER __BYTE_ORDER
#else /*WITH_FLASH_NATIVE_ORDER*/
  #define FLASH_BYTE_ORDER __BYTE_ORDER
#endif /*WITH_FLASH_NATIVE_ORDER*/


#if 1
  #define FLASH_WR32(adr,val) (*(volatile uint32_t*)(adr)=(val))
  #define FLASH_RD32(adr) (*(volatile uint32_t*)(adr))
  #define FLASH_WR16(adr,val) (*(volatile uint16_t*)(adr)=(val))
  #define FLASH_RD16(adr) (*(volatile uint16_t*)(adr))
  #define FLASH_WR8(adr,val) (*(volatile uint8_t*)(adr)=(val))
  #define FLASH_RD8(adr) (*(volatile uint8_t*)(adr))
#endif

#define FLASH_ADDR_MASK  0x1ffff
#define FLASH_BLOCK_SIZE 0x20000


typedef struct flash_alg_info {
	int reserved;
} flash_alg_info_t;

typedef uint32_t flash_addr_t;

#define FLASH_INFO_MANUFACTURE_CODE 0
#define FLASH_INFO_DEVICE_CODE      1
#define FLASH_INFO_BLOCK_LOCK_STATE 2
#define FLASH_INFO_CFI_SIZE_LOG2    0x27

int strataflash_check_id_x16(const flash_alg_info_t *alg, flash_addr_t addr, int retid[2]);
int strataflash_prog_x16(const flash_alg_info_t *alg, flash_addr_t addr, const void *data, long count);
int strataflash_erase_x16(const flash_alg_info_t *alg, flash_addr_t addr, long size);
int strataflash_getinfo_x16(const struct flash_alg_info *alg, flash_addr_t addr, int what, unsigned long *infobuf);


#endif /*_FLASHLIB_H*/
