#ifndef _STRATAFLASH_MODULE
 #define _STRATAFLASH_MODULE

#define FLASHWORD(x) (x)

#define FLASH_Read_ID                   FLASHWORD( 0x90 )
#ifndef CYGOPT_FLASH_IS_BOOTBLOCK
#define FLASH_Read_Query                FLASHWORD( 0x98 ) // Strata only
#endif
#define FLASH_Read_Status               FLASHWORD( 0x70 )
#define FLASH_Clear_Status              FLASHWORD( 0x50 )
#define FLASH_Status_Ready              FLASHWORD( 0x80 )
#ifdef CYGOPT_FLASH_IS_BOOTBLOCK
#define FLASH_Program                   FLASHWORD( 0x40 ) // BootBlock only
#else
#define FLASH_Program                   FLASHWORD( 0x10 )
#endif
#define FLASH_Block_Erase               FLASHWORD( 0x20 )
#ifndef CYGOPT_FLASH_IS_BOOTBLOCK
#ifndef CYGOPT_FLASH_IS_NOT_ADVANCED
#define FLASH_Write_Buffer              FLASHWORD( 0xE8 ) // *Advanced* Strata only
#endif // flash is advanced ie. has Write Buffer command
#define FLASH_Set_Lock                  FLASHWORD( 0x60 ) // Strata only
#define FLASH_Set_Lock_Confirm          FLASHWORD( 0x01 ) // Strata only
#define FLASH_Clear_Locks               FLASHWORD( 0x60 ) // Strata only
#define FLASH_Clear_Locks_Confirm       FLASHWORD( 0xD0 ) // Strata only
#endif
#define FLASH_Confirm                   FLASHWORD( 0xD0 )
//#define FLASH_Configure                       FLASHWORD( 0xB8 )
//#define FLASH_Configure_ReadyWait             FLASHWORD( 0x00 )
//#define FLASH_Configure_PulseOnErase          FLASHWORD( 0x01 )
//#define FLASH_Configure_PulseOnProgram        FLASHWORD( 0x02 )
//#define FLASH_Configure_PulseOnBoth           FLASHWORD( 0x03 )
#define FLASH_Reset                     FLASHWORD( 0xFF )

// Status that we read back:
#define FLASH_ErrorMask                 FLASHWORD( 0x7E )
#define FLASH_ErrorProgram              FLASHWORD( 0x10 )
#define FLASH_ErrorErase                FLASHWORD( 0x20 )

#endif /*_STRATAFLASH_MODULE*/

