// vector class that represents vector in mathematics
// $Id: mathvector.hh,v 1.10 1999/02/20 06:21:56 hideto Exp $
//
// Copyright (C) 1999  Hideto Ishibashi
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "../rtl_mman/rtnew.hh"

#ifndef _MATHVECTOR_HH_
#define _MATHVECTOR_HH_


class MathVector
{
public:
	MathVector();
	MathVector(unsigned int size);
	MathVector(const MathVector&);
	MathVector& operator =(const MathVector&);
	virtual ~MathVector();

	// member operations
	virtual double& operator ()(unsigned int i);  // Index is from 1 to n(m_v).
	virtual const double& operator ()(unsigned int i) const;
	virtual unsigned int size() const { return m_size; }
	virtual MathVector cut(unsigned int from, unsigned int to) const;
		// the parameter pair (from > to) is allowed
	virtual MathVector cat(const MathVector&) const;

	// binary operations
	friend MathVector vector_add(const MathVector&, const MathVector&);
	friend MathVector vector_sub(const MathVector&, const MathVector&);
	friend MathVector vector_mul(const MathVector&, const double&);
	friend MathVector vector_div(const MathVector&, const double&);
	friend double vector_inp(const MathVector&, const MathVector&);

	// unary operators
	virtual MathVector operator -() const;
	virtual MathVector operator +=(const MathVector&);
	virtual MathVector operator -=(const MathVector&);
	virtual MathVector operator *=(const double&);
	virtual MathVector operator /=(const double&);

private:
	unsigned int	m_size;
	double			*m_element;

private:
	virtual void initialize(const double&);
	virtual void initialize(const MathVector&);
	virtual void allocate(unsigned int size);
	virtual void destroy();
};


//////////////////////////////////////////////////////////////////
// binary operators


MathVector operator +(const MathVector&, const MathVector&);
MathVector operator -(const MathVector&, const MathVector&);
MathVector operator *(const MathVector&, const double&);
MathVector operator *(const double&, const MathVector&);
MathVector operator /(const MathVector&, const double&);
double operator *(const MathVector&, const MathVector&);


//////////////////////////////////////////////////////////////////
// binary operators


inline
MathVector
operator +(const MathVector& a_var1, const MathVector& a_var2)
{ return vector_add(a_var1, a_var2); }

inline
MathVector
operator -(const MathVector& a_var1, const MathVector& a_var2)
{ return vector_sub(a_var1, a_var2); }

inline
MathVector
operator *(const MathVector& a_var1, const double& a_var2)
{ return vector_mul(a_var1, a_var2); }

inline
MathVector
operator *(const double& a_var1, const MathVector& a_var2)
{ return vector_mul(a_var2, a_var1); }

inline
MathVector
operator /(const MathVector& a_var1, const double& a_var2)
{ return vector_div(a_var1, a_var2); }

inline
double
operator *(const MathVector& a_var1, const MathVector& a_var2)
{ return vector_inp(a_var1, a_var2); }


//////////////////////////////////////////////////////////////////
// unary operators


inline
MathVector
MathVector::operator -() const
{
	return vector_mul(*this, double(-1));
}


#endif // _MATHVECTOR_HH_
