// MathVector/MathMatrix test
// $Id: matvectest.cc,v 1.4 1999/02/19 15:44:25 hideto Exp $
//
// Copyright (C) 1999  Hideto Ishibashi
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include <iostream.h>
#include "mathmatrix.hh"
#include "mathvector.hh"

void vecdemo(void);
void matdemo(void);
void matvecdemo(void);
void printvec(MathVector, const char*);
void printmat(MathMatrix, const char*);

#define PVEC(a)	(printvec((a),(#a)))
#define PMAT(a)	(printmat((a),(#a)))


int
main(void)
{
	vecdemo();
	matdemo();
	matvecdemo();
	
	return 0;
}


void
vecdemo(void)
{
	cout << "MathVector test" << endl;
	
	{ // member operation
		MathVector a(4);
		a(1) = 1; a(2) = 2; a(3) = 3; a(4) = 4;
		PVEC(a);
		PVEC(MathVector(a));
		
		MathVector b(4);
		b(1) = 5; b(2) = 6; b(3) = 7; b(4) = 8;
		PVEC(b);
		
		MathVector c(a);
		PVEC(c);
		
		PVEC(a.cut(2,3));
		PVEC(a.cut(4,1));
		PVEC(a.cat(b));
		PVEC(a.cut(2,3).cat(b));
	}
	
	{  // mathematical operation
		MathVector x(3);
		x(1) = 1; x(2) = 2; x(3) = 3;
		PVEC(x);
		
		MathVector y(3);
		y(1) = 3; y(2) = 5; y(3) = 6;
		PVEC(y);

		MathVector z;
		PVEC((z=y-x));
	
		PVEC((x*3));
		PVEC((x/2));
		PVEC((x=y));
		PVEC((x=x));
		cout << "x*y = " << x*y << endl;
	}
}


void
matdemo(void)
{
	cout << "MathMatrix test" << endl;
	
	{
		MathMatrix X(3,3);
		X(1,1) = 1; X(1,2) = 2; X(1,3) = 3;
		X(2,1) = 4; X(2,2) = 5; X(2,3) = 6;
		X(3,1) = 7; X(3,2) = 8; X(3,3) = 9;

		MathMatrix Z(X);
		PMAT(Z);
		PMAT(MathMatrix(X));
		
		PMAT(X);
		PMAT(X.cut(2,2,3,3));

		PMAT(-X);
		PMAT(X.t());

		MathMatrix Y;
		PMAT((Y=X));
		PMAT((X*=2));
		PMAT((X-=Y));
		PMAT((X*X));
	}
}


void
matvecdemo(void)
{
	{
		MathMatrix A(3,3);
		A(1,1) = 1; A(1,2) = 2; A(1,3) = 3;
		A(2,1) = 4; A(2,2) = 5; A(2,3) = 6;
		A(3,1) = 7; A(3,2) = 8; A(3,3) = 9;
		PMAT(A);

		MathMatrix B(3,1);
		B(1,1) = 1;
		B(2,1) = 2;
		B(3,1) = 3;
		PMAT(B);

		MathMatrix C(2,3);
		C(1,1) = 1; C(1,2) = 2; C(1,3) = 3;
		C(2,1) = 4; C(2,1) = 5; C(2,3) = 6;
		PMAT(C);

		MathVector x(3);
		x(1) = 3; x(2) = 2; x(3) = 1;
		PVEC(x);
		
		MathVector u(1);
		u(1) = 1;
		PVEC(u);

		MathVector xdot;
		PVEC((xdot = (A * MathMatrix(x) + B * MathMatrix(u)).asVector()));
		PMAT(xdot);
		
		MathVector y;
		PVEC((y = (C * MathMatrix(xdot)).asVector()));
		PMAT(y);
	}
}


void
printvec(MathVector a, const char *name)
{
	cout << name << "[" << a.size() << "] = ";
	
	cout << a(1);
	for (unsigned int i = 2; i <= a.size(); i++)
	{
		cout << ' ' << a(i);
	}
	cout << endl;
}


void
printmat(MathMatrix a, const char *name)
{
	cout << name << "[" << a.rsize() << "x" << a.csize() << "] =" << endl;
	for (unsigned int i = 1; i <= a.rsize(); i++)
	{
		for (unsigned int j = 1; j <= a.csize(); j++)
		{
			cout << ' ' << a(i,j);
		}
		cout << endl;
	}
}
