#include <linux/module.h>
#include <linux/version.h>

#include <rtl.h>
#include <time.h>
#include <pthread.h>

#include "modelo.h"

pthread_t thread;

void * start_routine(void *arg)
{
	double salida;

	struct sched_param p;
	p . sched_priority = 1;
	pthread_setschedparam (pthread_self(), SCHED_FIFO, &p);

	pthread_make_periodic_np (pthread_self(), gethrtime(), 500000000);

	while (1) {
		Actualiza_modelo();
		salida=Salidas_modelo();
		pthread_wait_np ();
		rtl_printf("salida=%f\n", salida);
	}
	return 0;
}

int init_module(void) {
	Inicializa_modelo();
	return pthread_create (&thread, NULL, start_routine, 0);
}

void cleanup_module(void) {
	Finaliza_modelo();
	pthread_delete_np (thread);
}
