/* SimpleWaveIrq RTAI version 
   Phil Wilshire Nov 1999 
   License .. GPL 
   Produce a pulse on pin 9 of the parallel port link this to pin 10 and force an interrupt 
*/ 

/* RTLinux version Nicolas Ferre */

#include <linux/module.h> 
#include <linux/kernel.h> 
#include <linux/version.h> 
#include <linux/cons.h> 

#include <pthread.h> 

#include <asm/io.h> 

#include <rtl.h> 
#include <rtl_sync.h>   /* for RT_TASK */ 
#include <rtl_sched.h>
#include <rtl_conf.h>
#include <rtl_core.h>

#define LPT_PORT 0x3bc  /**** could be 0x378 on your PC ****/
#define LPT_STAT LPT_PORT + 1
#define LPT_CONT LPT_PORT + 2
#define LPT_IRQ 7 

#define ONE_MS 1000000 /* in nSecs */ 

static hrtime_t tresp;  /* response time */
static hrtime_t ttrig;  /* trigger time */

static int irq_count = 0; /*count of irqs*/
static int tas_count = 0; /*count of task triggers*/

int tperiod = ONE_MS*700;

unsigned int intr_handler( unsigned int com, struct pt_regs *r ) {
 /* get the response time */
 if (irq_count == 1 ) tresp = clock_gethrtime(rtl_getschedclock());
 /* count interrupts */ 
 rtl_hard_disable_irq(LPT_IRQ);
 irq_count++; 
 rtl_printf("in handler %d time(s)\n",irq_count);

 /* toggle data 1 (pin 2) and ...*/
 /* ... reset interrupt */
 if (irq_count % 2) outb(inb(LPT_PORT) &~(0x81),LPT_PORT);
 else               outb(inb(LPT_PORT) &~(0x80),LPT_PORT);
 rtl_hard_enable_irq(LPT_IRQ);

 return 0;
}

void cleanup_irq(void) {
/* rtl_printf("in cleanup_irq\n");
 */
 outb_p(inb_p(0x21) | (0x80),0x21);
 outb_p(inb_p(LPT_CONT)&~(0x10),LPT_CONT); 
 // use rt compat form 
 rtl_free_irq(LPT_IRQ);
} 

void setup_irq(void) { 
/* rtl_printf("in setup_irq\n");
 */
 outb_p(inb_p(0x21)&~(0x80),0x21);
 outb_p(0x20,0x20);
 outb_p(inb_p(LPT_CONT)|(0x10),LPT_CONT);
 /* reset interrupt */ 
 outb(inb(LPT_PORT) &~(0x81),LPT_PORT); 

 /*use the RT fcn */
 if(!rtl_request_irq(LPT_IRQ, intr_handler))
   rtl_hard_enable_irq(LPT_IRQ);
 else rtl_printf("unable to setup irq\n");
}


pthread_t mytask; 

void *fun(void * myt) { 
 hrtime_t next;
 
 /* delay the start */ 
 next = clock_gethrtime(rtl_getschedclock())+ tperiod; 
 
 pthread_make_periodic_np(pthread_self(), next,tperiod); 

 while(1){ 
   /* get the response time */ 
   if (tas_count == 1 ) ttrig = clock_gethrtime(rtl_getschedclock());
   outb(0xff, LPT_PORT);; /* write on the parallel port */ 
   tas_count++; 
   pthread_wait_np();
 }
}


hrtime_t tstart1; 
hrtime_t now; 

 int init_module(void){
 int tstatus; 
 pthread_attr_t attr; 
 struct sched_param sched_param; 

 pthread_attr_init (&attr); 
 pthread_attr_setcpu_np(&attr, 0); 
 sched_param.sched_priority = 1; 
 pthread_attr_setschedparam (&attr, &sched_param); 

 /* set up for IRQ's */ 
 setup_irq();

 tstatus = pthread_create (&mytask, &attr, fun, (void *)0); 
 return 0; 
} 

void cleanup_module(void){ 

 hrtime_t rt = 0; 

 rt = tresp-ttrig; 

 pthread_delete_np(mytask); 
 cleanup_irq(); 

 printk(" irq_count = %d \n",irq_count); 
 printk(" tas_count = %d \n",tas_count); 
 printk(" latency = %d ns\n",(int)rt); 
}

