/* SimpleWaveIrq RTAI version 
Phil Wilshire Nov 1999 
License .. GPL 
Produce a pulse on pin 9 of the parallel port link this to pin 10 and force an interrupt 
*/ 
#include <linux/module.h> 
#include <linux/kernel.h> 
#include <linux/version.h> 
#include <asm/io.h> 
#include <rtai.h> 
#include <rtai_sched.h>/* for RT_TASK */ 

#define TICK_PERIOD 500000 /* nanoseconds = 500uSecs*/ 

#define LPT_PORT 0x378 
#define LPT_CONT 0x378 + 2 
#define LPT_IRQ 7 

static RTIME tresp; /* response time */ 
static RTIME trig; /* trigger time */ 
static int irq_count = 0; /* count of irqs */ 
static int tas_count = 0; /* count of task triggers */ 

static void intr_handler(void) { 
 /* get the response time */ 
 if (irq_count == 1 ) tresp = rt_get_time(); /* reset interrupt */ 
 outb(inb(LPT_PORT) &~(0x81),LPT_PORT); /* count interrupts */ 
 irq_count++; 
} 

void cleanup_irq(void) { 
 outb_p(inb_p(LPT_CONT)&~(0x10),LPT_CONT); 
 // use rt compat form 
 free_RTirq(LPT_IRQ); 
} 

void setup_irq(void) { 
 outb_p(inb_p(0x21)&~(0x80),0x21);
 outb_p(0x20,0x20);
 outb_p(inb_p(LPT_CONT)|(0x10),LPT_CONT); 
 //use the RT compat fcn 
 request_RTirq(LPT_IRQ, intr_handler); 
 /* reset interrupt */ 
 outb(inb(LPT_PORT) &~(0x81),LPT_PORT); 
} 
RT_TASK mytask; 

void fun(int t) { 
 while(1){ 
 /* get the response time */ 
 if (tas_count == 1 ) ttrig = rt_get_time(); 
 outb(0xff, LPT_PORT);; 
 /* write on the parallel port */ 
 tas_count++; 
 rt_task_wait_period(); 
 } 
} 

RTIME tstart1; 
RTIME now; 

int init_module(void){ 
 RTIME tperiod; 
 /* set up for IRQ's */ 
 setup_irq(); 

 /* this task will be setting the bit */ 
 rt_task_init(&mytask, fun, 0, 3000, 4,0,0); 

 rt_set_oneshot_mode(); 
 tperiod = start_rt_timer(nano2count(TICK_PERIOD)); 
 now = rt_get_time(); 

 /* delay the start */ 
 tstart1 = now + nano2count(10000000); 
 rt_task_make_periodic(&mytask, tstart1, tperiod); 
 return 0; 
} 

void cleanup_module(void){ 

 int irqlate; 
 RTIME rt; 

 rt = tresp-ttrig; 
 irqlate = count2nano(rt)/1000 ; 

 stop_rt_timer(); 
 rt_busy_sleep(1E7); 
 rt_task_delete(&mytask); 

 cleanup_irq(); 
 printk(" irq_count = %d \n",irq_count); 
 printk(" tas_count = %d \n",tas_count); 
 printk(" latency = %d uSecs\n",irqlate); 
}

 

