/* -*- C -*- ***************************************************
 * $Id: debug.h,v 1.5 2000/04/18 09:13:47 opetzold Exp $
 *
 * DESCRIPTION:	macros and functions for debugging
 *
 *
 * 
 * Copyright (C) 2000 O.Petzold <opetzold@wit.regiocom.net>
 */

#ifndef RTREG_DEBUG_H
#define RTREG_DEBUG_H

#define DBG_LEVEL_MAX	4
#define DBG_LEVEL_MIN	0



/* datatypes */
typedef unsigned int dbg_level_t;



#if defined(__KERNEL__) && defined(MODULE)
/*****************************************
 * kernel space
 */
extern dbg_level_t rtreg_debug_level;		/* the default debug level (rtreg_main.c) */
extern const char *kernel_errlist;		/* (kernel_errlist.c) */
extern const char *kstrerror(int errno);	/* (kernel_errlist.c) */


/* handle with klogd */
#if defined(__RTL__)

#include <rtl_printf.h>

#define RTREG_DEBUG(level, msg...) do { \
	if (level <= rtreg_debug_level) \
		rtl_printf(KERN_DEBUG "RTREG_DBG: " ##msg); \
	} while (0)

#define RTREG_INFO(msg...) \
	rtl_printf(KERN_INFO "RTREG_INFO: " ##msg)

#define RTREG_ERR(msg...) \
        rtl_printf(KERN_ERR "RTREG_ERR: " ##msg)

#define RTREG_WARN(msg...) \
	rtl_printf(KERN_WARNING "RTREG_WARN: " ##msg)

#else /* !__RTL__ */

#define RTREG_DEBUG(level, msg...) do { \
	if (level <= rtreg_debug_level) \
		printk(KERN_DEBUG "RTREG_DBG: " ##msg); \
	} while (0)

#define RTREG_INFO(msg...) \
	printk(KERN_INFO "RTREG_INFO: " ##msg)

#define RTREG_ERR(msg...) \
	printk(KERN_ERR "RTREG_ERR: " ##msg)

#define RTREG_WARN(msg...) \
	printk(KERN_WARNING "RTREG_WARN: " ##msg)

#endif /* !__RTL__ */


#else
/*****************************************
 * user space
 */
extern dbg_level_t gui_debug_level;		/* the default debug level (main.cc) */

#define GUI_DEBUG(level, msg...) do { \
	if (level <= gui_debug_level) \
		qDebug(##msg); \
        } while(0)

#endif


#endif /*  RTREG_DEBUG_H */
