/* file: das6402-config.c */
/* steve rosenbluth JHCS 2-2000 */
/* compile with: gcc -I/usr/src/linux/include -O2 -o das6402-config das6402-config.c */
/*  epson dot-matrix printer condense code */

/*---------------------------------------------------------------------------

 This app sends config/action messages to the pci-das6402 driver via ioctl

    Copyright (C) 2000 Jim Henson's Creature Shop
    written by Steve Rosenbluth
        (stever8@earthlink.net, stever@la.creatureshop.henson.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

---------------------------------------------------------------------------*/


#include "pci-das6402-config.h"                                         /* defs for talking to driver */
/*#include "../motion_engine/pci-das6402-config.h"*/                            /* defs for talking to driver (henson sourcetree path)*/
#include <sys/mman.h>                                                       /* for mlock() */
#include <sys/types.h>                                                      /* for open, flags */
#include <sys/stat.h>
#include <fcntl.h>


/****************************/
int main(int argc, char *argv[])
{
    char mode = '!';
    int fd_ctl;                                                              /* file descriptor for das6402 device */
    int ioc_cmd = NONE;
    ctl_msg_struct_t ctl_msg;                                                /* for talking to daq driver */
    const char devstr[] = {"/dev/pci-das6402"};

    mlock(&ctl_msg, sizeof(ctl_msg_struct_t));                               /* we lock memory so our struct can be read by driver */

    if (argc > 1)
    {
        sscanf(argv[1], "%c", &mode);                                        /* convert ascii hex port value to decimal */
        if (argc > 2)
        {
            if (mode == 'f')   
                sscanf(argv[2],"%u",&ctl_msg.sample_rate);                        /* capture unsigned divisor */
            else if (mode == 'o')                                                   /* digital output */
                ctl_msg.dout_val_a  = ctl_msg.dout_val_b = ctl_msg.dout_val_c =
                    ctl_msg.dout_val_aux = atoi(argv[2]);                   /* convert byte to output */
            else if (strncmp(argv[2], "10", 2) == 0)                        /* continuous or burst mode*/
                ctl_msg.volt_range = BI_TEN_VOLT;
            else if (strncmp(argv[2], "5", 1) == 0)
                ctl_msg.volt_range = BI_FIVE_VOLT;
            else if (strncmp(argv[2], "2.5", 3) == 0)
                ctl_msg.volt_range = BI_TWO_VOLT;
        }

        if ((fd_ctl = open(devstr, O_WRONLY)) < 0)            /* this device is for this proc to send commands to device driver */
        {
            perror("das6402-config: Error opening %s",devstr);
            exit(1);
        }
    }
    else
    {
        printf("Usage: das6402-config [c b g s o f] [[10,5,2.5] [0-255] [2-65535]]\nc: continuous acq\nb: burst acq\ng: 'go' sample\n"
            "s: stop sampling\no: digital output\nf: set frequency divisor\nq: query driver variables\n10,5,2.5: voltage range\n"
            "0-255: digital output value (dec)\n2-65535: frequency divisor\n");
        exit(0);
    }

    if (mode == 'c')                                                           /* continuous acq */
    {
        ctl_msg.command = CONFIGURE_ACQUISITION;
        ctl_msg.conversion_mode = CONTIN_ACQUISITION;
        /*ctl_msg.num_chan = 64;*/
        ctl_msg.lo_scan_chan = 0;
        ctl_msg.hi_scan_chan = 63;
/*        ctl_msg.single_chan = -1;*/
        ctl_msg.num_scans = 1;
        /* volt range set elsewhere */
/*        ctl_msg.adc_rate_divisor = 800;*/
        ctl_msg.sample_rate = 50000;
        /* dio_output_val not settable here */
        ioc_cmd = CONFIGURE_ACQUISITION;
    }
    else if (mode == 'b')                                                      /* burst acq */
    {
        ctl_msg.command = CONFIGURE_ACQUISITION;
        ctl_msg.conversion_mode = BURST_ACQUISITION;
        /*ctl_msg.num_chan = 64;*/
        ctl_msg.lo_scan_chan = 0;
        ctl_msg.hi_scan_chan = 63;
/*        ctl_msg.single_chan = -1;*/
        ctl_msg.num_scans = 1/*128*/;
        /* volt_range set above */
/*        ctl_msg.adc_rate_divisor = 800;*/
        ctl_msg.sample_rate = 1000/*50000*/;
        /* dio_output_val not settable here */
        ctl_msg.dio_a_dir = IN;                                             /* config port directions */
        ctl_msg.dio_b_dir = OUT;
        ctl_msg.dio_c_lo_dir = OUT;
        ctl_msg.dio_c_hi_dir = IN;
        ioc_cmd = CONFIGURE_ACQUISITION;
    }
    else if (mode == 'g')                                                      /* "go" start acq */
    {
        ctl_msg.command = START_ACQUISITION;
        ctl_msg.conversion_mode = START_ACQUISITION;
        ioc_cmd = START_ACQUISITION;
    }
    else if (mode == 's')                                                      /* stop acq */
    {
        ctl_msg.command = STOP_ACQUISITION;
        ctl_msg.conversion_mode = STOP_ACQUISITION;
/*        ctl_msg.adc_rate_divisor = -1;*/
        ioc_cmd = STOP_ACQUISITION;
    }
    else if (mode == 'o')                                                      /* stop acq */
    {
        ctl_msg.command = DIGITAL_OUTPUT;
        /* value is already in ctl_msg.dio_output_val */
        ioc_cmd = DIGITAL_OUTPUT;
    }
    else if (mode == 'f')                                                      /* freq adj */
    {
        ctl_msg.command = CONFIGURE_ACQUISITION;
        ctl_msg.conversion_mode = -1;
/*        ctl_msg.num_chan = -1;*/
/*        ctl_msg.single_chan = -1;*/
        ctl_msg.num_scans = -1;
        /* user supplied divisor is already in ctl_msg.adc_rate_divisor */
        ioc_cmd = CONFIGURE_ACQUISITION;
    }
    else if (mode == 'q')
    {
        ctl_msg.command = -1;
        ctl_msg.conversion_mode = -1;
        ioc_cmd = QUERY_ACQUISITION;
    }
    else
        ioc_cmd = NONE;

    if (ioc_cmd != NONE)
    {
        printf("addr of our struct is %p\n",&ctl_msg);
        if (ioctl(fd_ctl, ioc_cmd, &ctl_msg) < 0)                          /* write startup message to device */
            perror("das6402-config: Error writing file descriptor");

        /*printf("fake ioctl: cmd = %d\n",ioc_cmd);*/
    }

    /* printf("\nSent message to das6402 ...\ncommand: %d, conversion_mode: %d, num_chan: %d, single_chan: %d, num_adc_banks: %d,
     * timer_period: %d\n",
     * ctl_msg.command,ctl_msg.conversion_mode,ctl_msg.num_chan,ctl_msg.single_chan,ctl_msg.num_adc_banks,ctl_msg.timer_period); */

    sleep(1);                                                               /* wait for driver to read our struct */

    return 0;
}
