/*======================================================================

    pci-das6402-config.h    v0.01    2000/1/21
    Defs for interfacing with pci-das6402.c driver
    Include this for reading and writing to the driver

    Copyright (C) 2000 Jim Henson's Creature Shop
    written by Steve Rosenbluth
        (stever8@earthlink.net, stever@la.creatureshop.henson.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

======================================================================*/
/*  epson dot-matrix printer condense code */

#ifndef _DAS6402_CONFIG_H_   /* include protection */
#define _DAS6402_CONFIG_H_

#define STOP_ACQUISITION        0                                           /* command flags sent to daq driver in ioctl control struct */
#define START_ACQUISITION       1
#define CONFIGURE_ACQUISITION   2
#define BURST_ACQUISITION       3
#define CONTIN_ACQUISITION      4
#define DIGITAL_OUTPUT          5
#define QUERY_ACQUISITION       6
#define SINGLE_ENDED            0x1000
#define DIFFERENTIAL            0x0000
#define BI_TEN_VOLT             0
#define BI_FIVE_VOLT            0x100
#define BI_TWO_VOLT             0x200
#define BI_ONE_VOLT             0x300
#define UNI_TEN_VOLT            0x800
#define UNI_FIVE_VOLT           0x900
#define UNI_TWO_VOLT            0xA00
#define UNI_ONE_VOLT            0xB00
#define CLR_2_LSB_INT32         0xFFFC                                      /* AND mask to clear two low bits of an int32 */
#define MAX_SAMPLE_RATE_HZ      200000                                      /* maximum supported conversion rate */
#define INTERNAL_CLOCK_HZ       40000000                                    /* card has a 40Mhz internal clock */
#define MAX_BANKS               128                                         /* max number of banks of 64 samples we can get in burst mode */
#define DAS6402_FIFO_SIZE       8192                                        /* size of internal hardware FIFO */
#define MAX_CHANNELS            64                                          /* can sample a quantity of 1-64 channels on this card */
#ifndef TRUE
    #define TRUE                1
#endif
#ifndef FALSE
    #define FALSE               0
#endif
#define NONE                    -1
#define IN                      1
#define OUT                     0

#define DAS6402_IOC_MAGIC       0xAD                                        /* magic number for our ioctl, not registered w/ Linus ! */
#define DAS6402_IOC_CONFIGURE        _IOW(DAS6402_IOC_MAGIC,1,ctl_msg_struct_p)
#define DAS6402_IOC_CLR_USAGE_CNT    _IO(DAS6402_IOC_MAGIC,2)

#define SAMPLE_HEADER_SIZE      3                                           /* we put this much of a header in each result packet */
#define SAMPLE_HEADER_MAGIC_1   0xCB                                        /* identifies begin of a result packet */
#define SAMPLE_HEADER_MAGIC_2   0xADC                                       /* identifies begin of a result packet */
#define HDR_MAGIC_OFFSET        0                                           /* place in result packet where magic num is found */
#define HDR_MUX_OFFSET          2                                           /* place in result packet where mux value is found */
#define DIG_IN_OFFSET           3                                           /* place in result packet where digital input data found */
#define ADC_DATA_OFFSET         4                                           /* place in result packet where analog input data found */
#define ADC_DATA_QTY            MAX_CHANNELS                                /* num adc samples per result packet */
#define DIG_DATA_QTY            1
#define RESULT_SIZE_B           2                                           /* size of each adc result in bytes */
#define RESULT_SIZE_SI          1                                           /* size of each adc result (unsigned 16 bit) */
#define RESULT_PACK_SIZE_B      (RESULT_PACK_SIZE_SI*2)                     /* number of bytes in a single result packet */
#define RESULT_PACK_SIZE_SI     (SAMPLE_HEADER_SIZE+DIG_DATA_QTY+ADC_DATA_QTY) /*20*//* number of u16's in a single result packet */
#define MAX_SCANS               (DAS6402_FIFO_SIZE/MAX_CHANNELS)     /* 8192/64) arbitrary ?!? */
#define MAX_RESULT_PACKETS      MAX_SCANS                            /* driver (& card) holds this many sample packets (of 64 results) */
#define DAS_STOP                0
#define DAS_START               1
#define DAS_RESTART             2

/* Config struct sent to pci_das6402 driver. */
/* Values set to -1 will be ignored, previous settings then apply */
typedef struct {                                                    /* message sent to driver through rt-fifo to change daq parameters */
    int command;                                                            /* configure, start or stop conversions. see constants */
    int conversion_mode;                                                    /* set to continuous mode, burst mode, (see constants) */
    int num_chan;                                                           /* quantity (of 64) channels to scan. valid: 1-64 */
    int lo_scan_chan;                                                       /* first (of 64) channels to scan. valid: 0-63 */
    int hi_scan_chan;                                                       /* last (of 64) channels to scan. valid: 0-63 */
    int num_scans;                                                          /* how many channel scans to convert. valid 1-MAX_SCANS */
    unsigned int volt_range;                                       /* 10 volt, 5V, 2.5V, 1.25V bipolar or single ended - see constants */
    int sample_rate;                                                        /* ADC sample rate (Hz). derived from 40MHz internal clock*/
/*    int adc_rate_divisor;*/                                                   /* configures ADC rate. divides down from 40MHz */
    char dio_a_dir;                                                         /* direction of primary dio port, use IN, OUT constants */
    char dio_b_dir;                                                         /* direction of primary dio port */
    char dio_c_lo_dir;                                                         /* direction of primary dio port */
    char dio_c_hi_dir;                                                         /* direction of primary dio port */
    unsigned char dout_val_a;                                                  /* val to be written to primary digital out port */
    unsigned char dout_val_b;                                                  /* val to be written to primary digital out port */
    unsigned char dout_val_c;                                                  /* val to be written to primary digital out port */
    unsigned char dout_val_aux;                                                /* valto be written to auxiliary digital out port */
} ctl_msg_struct_t;

#endif /* _DAS6402_CONFIG_H_ */
