/*============================================================================
    "pci-das6402.h"

    A Linux driver for the ComputerBoards PCI-DAS6402/16 data acquisition card
   
    Copyright (C) 2000 Jim Henson's Creature Shop
    written by Steve Rosenbluth
        (stever8@earthlink.net, stever@la.creatureshop.henson.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

=============================================================================*/
/*  epson dot-matrix printer condense code - yields 137 columns on 8.5x11 */

#ifndef _DAS_6402_H_                                       /* include protection*/
#define _DAS_6402_H_

#include "pci-das6402-config.h"                                                 /* common defs for users to compose ioctls, etc */

/*#define RTLINUX */                           /* if defined, compile for RTLinux irqs etc */

/******** BAR0 registers (32 bit space referred to by "plx9080_io_base") **********/
#define PCI_9080_INT_CTL_STAT_REG 0x68                                    /* PLX9080 controller chip interrupt control/status reg*/
#define PCI_9080_EEPROM_CTL_REG   0x6C                                    /* PLX9080 ctlr chip EEPROM Control, PCI cmd, user IO reg*/
#define PCI_9080_DMA_THRESH_REG   0xB0                                  /* PLX9080 DMA threshold register */
#define PCI_9080_DMA_CH1_CMD_STAT_REG 0xA9                                  /* DMA channel 1 command/status register */

/******** Local Space 0 registers (16 bit space referred to by "daq_io_base") **********/

/* configuration write-only registers */
#define INT_ENAB_REG            0x00                /* Interrupt Enable Register */
#define HDWRE_CFG_REG           0x02                                            /* Hardware Configuration Register */
#define MEM_CFG_REG             0x04                                            /* Memory Configuration Register */
/* Lspace0 read-only registers */
#define HDWRE_STAT_REG          0x00                /* hardware status */
/* ADC read registers */
#define PIPE1_READ_REG          0x04                /* PIPE1 read reg */
#define ADC_READ_PTR_REG        0x08                /* ADC read pointer  */
#define ADC_WRITE_PTR_REG       0x0C                /* ADC write pointer  */
#define LO_USR_XFER_CTR_REG     0x10                /* lower user xfer counter reg (LOW) */
#define PRE_POST_REG            0x14                /* pre-post register */
/* ADC write registers */
#define CONTROL_REG_0           0x10                                            /* Control Register 0 */
#define CONTROL_REG_1           0x12                                            /* Control Register 1 */
#define CALIB_CTRL_REG          0x14                /* calibration control */
#define SAMP_INTRVL_LO_REG      0x16                /* sample interval LOW */
#define SAMP_INTRVL_HI_REG      0x18                /* sample interval HIGH */
#define DELAY_INTRVL_LO_REG     0x1A                /* delay interval LOW */
#define DELAY_INTRVL_HI_REG     0x1C                /* delay interval HIGH */
#define SAMP_SCAN_CNT_LO_REG    0x1E                /* sample/scan count LOW */
#define SAMP_SCAN_CNT_HI_REG    0x20                /* sample/scan count HIGH */
#define DAQ_SOFT_START_REG      0x22                /* DAQ soft start command reg */
#define DAQ_SNGL_CONV_REG       0x24                /* DAQ single conversion command reg */
#define Q_FIFO_PTR_CLEAR_REG    0x26                /* QUEUE FIFO pointer clear command */
#define Q_LOAD_REG              0x28                /* QUEUE load command */
#define ADC_FIFO_PTR_CLR_REG    0x2A                /* ADC_FIFO pointer clear command */
#define Q_HIGH_REG              0x2C                /* QUEUE high register */
/* DAC registers */
    /* FIXME: finish these */
/* FIFO read/write registers */
#define QUEUE_FIFO_REG          0x100                /* queue fifo */
#define ADC_FIFO_REG            0x200                /* ADC FIFO register: for channel-scan results */
#define DAC_FIFOREG             0x300                /* DAC FIFO */

/******** Local Space 1 registers (8 bit space referred to by "dio_io_base") **********/
/* primary digital IO (available on internal 24 pin connector) */
#define PRI_DIO_A_PORT          0x00                /* primary digital port A */
#define PRI_DIO_B_PORT          0x01                /* primary digital port B */
#define PRI_DIO_C_PORT          0x02                /* primary digital port C */
#define PRI_DIO_CONFIG_REG      0x03                /* primary digital port control reg (8255)*/
/* user counter/timer */
#define USR_CTR_DATA_REG        0x08                /* counter data */
#define USR_CTR_CTL_REG         0x0B                /* counter control (one channel of an 8254) */
/* auxiliary digital IO (avail on 100 pin connector) */
#define AUX_DOUT_PORT           0x20                /* fixed digital out (4 LSBS) */
#define AUX_DIN_PORT 0x         0x28                /* fixed digital in (4 LSBS) */

/* Interrupt enable reg INT_ENAB_REG (0x00) OR masks*/
#define IRQ_END_SCAN            0x02
#define DAQ_IRQ_ENAB            0x04                /* DAQ operations cause IRQ */
#define DAQ_DONE                0x08
#define DAQ_ACTIVE              0x200
#define DAQ_OVERRUN             0x8000
#define EXTERN_INT_ENAB         0x100

/* Hardware Steus Reg HDWRE_STAT_REG (0x00) AND masks*/
#define EXTERN_INT_FLAG         0x100
#define DAQ_INT_FLAG            0x20

/* Hardware config reg HDWRE_CFG_REG (0x02) OR masks */
#define INTERN_CHAN_Q           0
#define EXTERN_CHAN_Q           0x200
#define DMA_CHAN0_DAQ           0
#define DMA_CHAN0_DAC           0x8000
#define EXTERN_INT_RISING       0                                           /* rising edge triggered external irqs  */
#define EXTERN_INT_FALLING      0x100                                       /* falling edge triggered external irqs */

/* memory config reg MEM_CFG_REG (0x04) OR masks */
#define DAQ_BUFF_1K              0xFF00
#define DAC_BUFF_1K              0x003F

/* DAQ control reg0 CONTROL_REG_0 (0x10) OR masks */
#define SOFT_TRIG               0x10
#define SOFT_GATE               0x01
#define AGATE_LEVEL_SENS        0x04
#define TRIG_2_FALL_EDGE        0x100
#define GATE_AFTER_SEQ          0x2000
#define DAQ_ENAB                0x8000                                  /* master data acq enable */
#define SAMPLE_CNT_ENAB         0x1000                                  

/* DAQ control reg 1 CONTROL_REG_1 (0x12) OR Masks */
#define MULTI_CHAN_MODE         0x4000
#define SOFT_DAQ_GATE           0x40

/* queue load reg Q_LOAD_REG (0x28) OR masks */
/*  defined in das6402-config.h
 SINGLE_ENDED            0x1000
 BI_TEN_VOLT             0x000
 BI_FIVE_VOLT            0x100
 BI_TWO_VOLT             0x200
 BI_ONE_VOLT             0x300
 UNI_TEN_VOLT            0x800
 UNI_FIVE_VOLT           0x900
 UNI_TWO_VOLT            0xA00
 UNI_ONE_VOLT            0xB00 */

/* PCI9080 interrupt control/status reg "INTCSR" (0x68) OR masks */
#define PCI_INT_ENAB            0x100
#define PCI_LOCAL_INT_ENAB      0x800
#define LOCAL_INT_OUT_ENAB      0x10000
#define LOCAL_DOORBELL_INT_ENAB 0x20000
/* PCI9080 interrupt control/status reg "INTCSR" (0x68) AND masks */
#define LOCAL_INT_ACTIVE        0x10000

#define MAX_6402_DEVICES 16                                                     /* max das6402 cards driver supports */
#define ERROR                   -1                                          /* for function return values */


/* Note: the following are defined in /usr/src/linux/include/linux/pci.h : */
/* #define PCI_VENDOR_ID_CBOARDS           0x1307 */
/* #define PCI_DEVICE_ID_CBOARDS_DAS1602_16 0x0001 */
/* new def for this device, not yet in /usr/src/linux/include/linux/pci.h */
#define PCI_DEVICE_ID_CBOARDS_DAS6402_16 0x001d                               /* pci-das6402/16 shows this id on pci bus */


/*  These macros are from cyclades.h
    copyright Randolph Bentson (bentson@grieg.seaslug.org)
    and/or Ivan Passos (ivan@cyclades.com).
    The original code is free software distributed under 
    the GNU General Public License. */
/***************************************
 * Memory access functions/macros      *
 * (required to support Alpha systems) *
 ***************************************/
#define cy_writeb(port,val)     {writeb((u8)(val),(void *)(port)); mb();}
#define cy_writew(port,val)     {writew((u16)(val),(void *)(port)); mb();}
#define cy_writel(port,val)     {writel((u32)(val),(void *)(port)); mb();}
#define cy_readb(port)  readb(port)
#define cy_readw(port)  readw(port)
#define cy_readl(port)  readl(port)

typedef unsigned char bool;

typedef struct pci_das6402_dev_priv_t {
    struct pci_das6402_dev_priv_t *next_dev;                                /* pointer to next das6402 device in llist */
    int id;                                                             /* an ID unique to this instance of device (use minor?!?) */
    void *pci_9080_cfg_base/*io_base_a*/;                                                     /* plx 9080 PCI chip ? */
    void *pci_iomap_cfg_base/*io_base_b*/;
    u16 *daq_io_base/*io16_base*/;                                          /* for 16bit memmapped registers: DAQ config regs */
    u8 *dio_io_base/*io8_base*/;                                            /* for 8bit memmapped registers: DIO, etc */
    u32 pci_iomap_cfg_base_size;                                            /* size of the region */
    unsigned int irq;                                                   /* the pci card's irq level */
    unsigned char bus;		                                        /* bus number */
    unsigned int dev_fn;		                                /* encoded device & function index */
    const char *name;                                                   /* we store the device's public name here */
    u32 sample_rate;                                                        /* sample rate for ADC */
    u16 adc_rate_divisor;
    int channel_scan;                                                       /* quantity channels to sample. valid 1-64 */
    u16 volt_range;                                                         /* bitmask for voltage range (gain) */
    bool start;
    bool send_dig_ins;                                                      /* flag for irq handler that inputs have changed */
    bool burst_acq;  /* if true: do a burst of all samples and stop sampling, else continuous acq */
    /*int num_mux_banks;*/  /* total num banks (chan scans) of adc chans through which driver should multiplex */
    int num_dig_in_banks;                                                     /* how many banks of digital input bits: 1 to 4 nibbles */
    u8 dio_config_word;                                               /* config word written to 8255 chip */
    char dio_a_dir;                                                         /* direction of primary dio port, use IN, OUT constants */
    char dio_b_dir;                                                         /* direction of primary dio port */
    char dio_c_lo_dir;                                                         /* direction of primary dio port */
    char dio_c_hi_dir;                                                         /* direction of primary dio port */
    u8 dout_val_a;                                                           /* val to be written to primary digital out port */
    u8 dout_val_b;                                                           /* val to be written to primary digital out port */
    u8 dout_val_c;                                                           /* val to be written to primary digital out port */
    u8 dout_val_aux;                                                         /* valto be written to auxiliary digital out port */
    u16 old_digital_input_word[MAX_BANKS];                                      /* stores input bytes for future comparison */
    char multiscanning;                                                     /* whether doing multiple scans in a burst */
    int cur_scan;                                                   /* current scan number of multi scan operation */
    int chan_cnt;                                                   /* current count of individual adc conversions */
    int num_scans;                                              /* quantity of scans requested */
    u16 lo_scan_chan;                                              /* limits of channel scan valid 0-63 */
    u16 hi_scan_chan;
    struct wait_queue read_q;                                               /* for blocking reads */
    u16 result_table[MAX_RESULT_PACKETS+1][RESULT_PACK_SIZE_SI]; /* table of result packets */
    int result_table_head;                                                  /* index to next available packet in result table */
    int result_table_tail;                                                  /* index to next free slot in result table */
    int result_pack_avail;
    u16 digital_input_word;                                                 /* temp storage for digital input */
    u16 daq_ctl_reg0_mask;                                                  /* for writing bitmaps to this register */
    u16 daq_ctl_reg1_mask;                                                  /* for writing bitmaps to this register */
} pci_das6402_dev_priv_t;

typedef struct {
    pci_das6402_dev_priv_t priv;    
    int dev_num;
} pci_das6402_dev_list_t;

#endif /*_DAS_6402_H_*/
