/* file: read6402.c */
/* by Steve Rosenbluth */
/* copyright 5-2000 Jim Henson's Creature Shop */
/* compile with: gcc -Wall -O2 -o read6402 read6402.c */

/*---------------------------------------------------------------------------

 This app reads ADC results from the pci-das6402 driver via read()

    Copyright (C) 2000 Jim Henson's Creature Shop
    written by Steve Rosenbluth
        (stever8@earthlink.net, stever@la.creatureshop.henson.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

---------------------------------------------------------------------------*/

#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>                                 /* for exit */
#include "pci-das6402-config.h"                      /* must include this for driver interface defs */
/*#include "../motion_engine/pci-das6402-config.h"*/         /* for henson source tree only */


/*********************************/
int main (int argc, char *argv[]) 
{
    int in_file, numrequested, numread, i;
    char dev_str[] = {"/dev/pci_das6402"};
    unsigned short result_packet[MAX_CHANNELS/*MAX_RESULT_PACKETS*/];
    
    if ((in_file = open(dev_str, O_RDONLY|O_NONBLOCK)) < 0) {
        perror("");
        printf("Error opening %s\n",dev_str);
        exit(-1);
    }
    else
        printf("using %s.\nbuf addr is %p\n",dev_str,result_packet);

    numrequested = MAX_CHANNELS*RESULT_SIZE_B;
    printf("Asking for %d bytes... ",numrequested);

    numread = read(in_file, result_packet, numrequested);    /* read in one result packets worth of bytes */

    printf("got %d bytes\n",numread);

    if (numread > 0) 
    {
        for(i=0; i < MAX_CHANNELS; i++)
            printf("%u ",result_packet[0]);
        printf("\n");
#if 0
        printf("m:%d ",result_packet[HDR_MUX_OFFSET]);                      /* print current mux value */
        printf("d:%d ",result_packet[DIG_IN_OFFSET]);                       /* print digitals value */
        for(i=0; i < MAX_CHANNELS; i++)
            printf("%d ",result_packet[ADC_DATA_OFFSET+i]);
        printf("\n");
#endif
    }
    else if (numread == 0)
        printf("End of file (no samples)\n");
    else
        perror("Error reading:");

    return 0;
}
