#include <linux/errno.h>
#include <linux/sched.h>
#include "rt_pend_tq.h"
#include <linux/rtl.h>

volatile static struct rt_pend_tq rt_pend_tq[RT_PEND_TQ_SIZE]; 
volatile static struct rt_pend_tq * volatile rt_pend_head= rt_pend_tq,
	* volatile rt_pend_tail = rt_pend_tq;
int rt_pend_tq_irq=0;

// WARNING: following code not checked against race conditions yet.
#define INC_CIRCULAR_PTR(ptr,begin,size) do {if(++(ptr)>=(begin)+(size)) (ptr)=(begin); } while(0)
#define DEC_CIRCULAR_PTR(ptr,begin,size) do {if(--(ptr)<(begin)) (ptr)=(begin)+(size)-1; } while(0)

int rt_pend_call(void (*func)(int arg1, void * arg2), int arg1, void * arg2)
{
	if(func==NULL)
		return -EINVAL;
	if(rt_pend_tq_irq<=0)
		return -ENODEV;
	INC_CIRCULAR_PTR(rt_pend_head,rt_pend_tq,RT_PEND_TQ_SIZE);
	if(rt_pend_head==rt_pend_tail) {
		// overflow, we just refuse to take this request
		DEC_CIRCULAR_PTR(rt_pend_head,rt_pend_tq,RT_PEND_TQ_SIZE);
		return -EAGAIN;
	}
	rt_pend_head->func=func;
	rt_pend_head->arg1=arg1;
	rt_pend_head->arg2=arg2;
	rtl_global_pend_irq(rt_pend_tq_irq);
	return 0;
}

void rt_pend_irq_handler(int irq, void *dev, struct pt_regs * regs)
{
	while(rt_pend_head!=rt_pend_tail) {
		INC_CIRCULAR_PTR(rt_pend_tail,rt_pend_tq,RT_PEND_TQ_SIZE);
		rt_pend_tail->func(rt_pend_tail->arg1,rt_pend_tail->arg2);
	}
}

int rt_pend_tq_init()
{
	rt_pend_head=rt_pend_tail=rt_pend_tq;
	return rt_pend_tq_irq=rtl_get_soft_irq(rt_pend_irq_handler,"rt_pend_irq");
}

void rt_pend_tq_cleanup()
{
	free_irq(rt_pend_tq_irq,NULL);
}
