diff -urN rtlinux-3.1/doc/Configure.help rtlinux-3.1_rtf_sizes_patched/doc/Configure.help
--- rtlinux-3.1/doc/Configure.help	Thu Jul 26 15:32:42 2001
+++ rtlinux-3.1_rtf_sizes_patched/doc/Configure.help	Mon Oct  1 14:19:36 2001
@@ -89,3 +89,12 @@
   to dramatically reduce scheduling jitter. You need a 2.4.X kernel
   with CONFIG_SMP enabled for this option to work.
 
+Extra fifo query functions 
+CONFIG_RTF_EXTRA_QUERYABLE
+  Say Y here if you want the ability to query an RTF's buffer size
+  and/or find the buffer fill of an RTF.  There is little overhead
+  in enabling this feature -- only three additional functions and 2
+  ioctls are compiled into the rtl_fifos.c code, however some users
+  might never use this and/or think this is wasteful, so it's 
+  safe to say N.  (Keep in mind, however, that real-time modules that use 
+  this feature may not work if you say N).
diff -urN rtlinux-3.1/fifos/rtl_fifo.c rtlinux-3.1_rtf_sizes_patched/fifos/rtl_fifo.c
--- rtlinux-3.1/fifos/rtl_fifo.c	Thu Jul 26 15:32:41 2001
+++ rtlinux-3.1_rtf_sizes_patched/fifos/rtl_fifo.c	Mon Oct  1 15:19:12 2001
@@ -304,6 +304,75 @@
 	return RTF_USER_OPEN(minor) != 0;
 }
 
+#ifdef CONFIG_RTF_EXTRA_QUERYABLE
+
+/* returns the number of bytes currently in the queue specified by minor 
+   returns -ENODEV or -EINVAL on error.
+   (the userspace equivalent ioctl is FIONREAD)   */
+int rtf_length(unsigned int minor)
+{
+	int ret;
+	rtl_irqstate_t interrupt_state;
+	
+	if (minor >= RTF_MAX_FIFO) 
+		return -ENODEV;
+	
+	if (!RTF_ALLOCATED(minor))
+		return -EINVAL;
+
+	rtl_spin_lock_irqsave(&RTF_SPIN(minor), interrupt_state);	
+	ret = RTF_LEN(minor);
+	rtl_spin_unlock_irqrestore(&RTF_SPIN(minor), interrupt_state);   
+
+	return ret;
+}
+
+/* returns the number of bytes in this RTF's buffer.
+   returns -ENODEV or -EINVAL on error 
+   (the userspace equivalent ioctl is IOCTL_RTF_GET_BUFSIZE) */
+int rtf_bufsize(unsigned int minor) 
+{
+	int ret;
+	rtl_irqstate_t interrupt_state;
+	
+	if (minor >= RTF_MAX_FIFO)
+		return -ENODEV;
+
+	if (!RTF_ALLOCATED(minor))
+		return -EINVAL;
+
+	rtl_spin_lock_irqsave(&RTF_SPIN(minor), interrupt_state);
+	ret = RTF_BUF(minor);
+	rtl_spin_unlock_irqrestore(&RTF_SPIN(minor), interrupt_state);
+
+	return ret;
+}
+
+/* Note the possible misnomer here: (this doesn't 'free' anything)
+   returns the number of bytes free in this RTF's buffer.  (Attempts to
+   rtf_put() to a FIFO that doesn't have enough free space will fail.)
+   returns -ENODEV or -EINVAL on error. 
+   (the userspace equivalent ioctl is IOCTL_RTF_GET_FREE) */
+int rtf_free(unsigned int minor)
+{
+	int ret;
+	rtl_irqstate_t interrupt_state;
+	
+	if (minor >= RTF_MAX_FIFO)
+		return -ENODEV;
+
+	if (!RTF_ALLOCATED(minor))
+		return -EINVAL;
+
+	rtl_spin_lock_irqsave(&RTF_SPIN(minor), interrupt_state);
+	ret = RTF_FREE(minor);
+	rtl_spin_unlock_irqrestore(&RTF_SPIN(minor), interrupt_state);
+	
+	return ret;
+}
+
+#endif
+
 int rtf_flush(unsigned int minor)
 {
 	rtl_irqstate_t interrupt_state;
@@ -409,6 +478,16 @@
 				val = RTF_LEN(minor);
 				put_user(val, (int *) arg);
 				break;
+#ifdef CONFIG_RTF_EXTRA_QUERYABLE
+			case IOCTL_RTF_GET_BUFSIZE:
+				val = RTF_BUF(minor);
+				put_user(val, (int *) arg);
+				break;
+			case IOCTL_RTF_GET_FREE:
+				val = RTF_FREE(minor);
+				put_user(val, (int *) arg);
+				break;
+#endif
 			default:
 				break;
 		}
diff -urN rtlinux-3.1/include/rtl_fifo.h rtlinux-3.1_rtf_sizes_patched/include/rtl_fifo.h
--- rtlinux-3.1/include/rtl_fifo.h	Thu Jul 26 15:32:41 2001
+++ rtlinux-3.1_rtf_sizes_patched/include/rtl_fifo.h	Mon Oct  1 15:37:27 2001
@@ -16,6 +16,14 @@
 #define RTF_MAX_FIFO (RTL_MAX_USER_FIFO + 8)
 #define RTF_SETSIZE 1
 
+#ifdef CONFIG_RTF_EXTRA_QUERYABLE
+
+#  define IOCTL_RTF_GET_BUFSIZE 0
+#  define IOCTL_RTF_GET_FREE 1
+#  define IOCTL_RTF_LAST IOCTL_RTF_GET_FREE
+
+#endif
+
 #ifdef __KERNEL__
 extern int rtf_init(void);
 
@@ -50,6 +58,27 @@
 extern int rtf_isempty(unsigned int fifo);
 
 extern int rtf_isused(unsigned int fifo);
+
+#ifdef CONFIG_RTF_EXTRA_QUERYABLE
+
+/* returns the number of bytes currently in the queue specified by minor
+   returns -ENODEV or -EINVAL on error.
+   (the userspace equivalent ioctl is FIONREAD)   */
+extern int rtf_length(unsigned int fifo);
+
+/* returns the number of bytes in this RTF's buffer.
+   returns -ENODEV or -EINVAL on error
+   (the userspace equivalent ioctl is IOCTL_RTF_GET_BUFSIZE) */
+extern int rtf_bufsize(unsigned int fifo);
+
+/* Note the possible misnomer here:
+   returns the number of bytes free in this RTF's buffer.  (Attempts to
+   rtf_put() to a FIFO that doesn't have enough free space will fail.)
+   returns -ENODEV or -EINVAL on error.
+   (the userspace equivalent ioctl is IOCTL_RTF_GET_FREE) */
+extern int rtf_free(unsigned int fifo);
+
+#endif
 
 extern int rtf_resize(unsigned int minor, int size);
 
diff -urN rtlinux-3.1/scripts/config.in rtlinux-3.1_rtf_sizes_patched/scripts/config.in
--- rtlinux-3.1/scripts/config.in	Thu Jul 26 15:32:41 2001
+++ rtlinux-3.1_rtf_sizes_patched/scripts/config.in	Mon Oct  1 14:35:14 2001
@@ -36,6 +36,7 @@
 bool 'Enable Debugging' CONFIG_RTL_DEBUG
 bool 'rtl_printf uses printk' CONFIG_RTL_SLOW_CONSOLE
 # bool 'POSIX Timeouts' _POSIX_TIMEOUTS
+bool 'Extra fifo query functions ' CONFIG_RTF_EXTRA_QUERYABLE 
 bool 'Nolinux support (experimental)' CONFIG_RTL_SUSPEND_LINUX
 bool 'RTLinux tracer support (experimental)' CONFIG_RTL_TRACER
 source main/arch/config.in
