#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/socket.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/proc_fs.h>
#include <linux/ioport.h>
#include <linux/net.h>

#include <rtai.h>
#include <rtai_lxrt.h>
#include <rtai_mbx.h>
#include <rtai_msg.h>
#include <rtai_fifos.h>
#include <rtai_sem.h>
#include <rtai_registry.h>
#include <rtnet.h>


MODULE_LICENSE("GPL");

/* Sequence:
 *
 * Clientr     Server
 *    -- 1472 -->
 *    --   32 -->
 *    <-- 800 ---
 * */


static int sock = -1;

static char *local_ip_addr = "192.168.8.2";

static RT_TASK server_task;

static short udp_port = 22222;

static long long timeout_ns = 1000000000LL;  // 1s timeout

#define RECVDATASIZE 1472
#define ACKNOWLEDGESIZE 800
static char recvdata[RECVDATASIZE];

/**
 * The data process handles the realtime data from the rtos_comm module.
 * Once initialized, the data process does the job...
 * */
static void *server_process(void *arg)
{
    int data_received = 0;
    unsigned int loop = 0;
    struct sockaddr_in sockaddr_client;
    rt_printk("server_process started\n");
    while (1)
    {
        int n_rec;
        int sockaddr_len = sizeof(sockaddr_client);

        /* Sequence: First receive a large message */

        n_rec = rt_dev_recvfrom(sock, recvdata, RECVDATASIZE, 0, 
                                (struct sockaddr*) &sockaddr_client, &sockaddr_len);

        if (n_rec > 0)
        {
            int rc;
            long long short_timeout_ns = 1000000; // 1ms

            data_received = 1;

            rt_dev_ioctl(sock, RTNET_RTIOC_TIMEOUT, &short_timeout_ns);

            if (n_rec < 100)
            {
                // This was the short message!
                // Read again to have the large message.
                rt_printk("Received the short message instead of the long message\n");
                n_rec = rt_dev_recv(sock, recvdata, RECVDATASIZE + 20, 0);
                if (n_rec < 0)
                {
                    rt_printk("The re-recv failed: %i\n", n_rec);
                }
                    
                
            }

            n_rec = rt_dev_recv(sock, recvdata, RECVDATASIZE, 0);

            if (n_rec > 0)
            {
                if (n_rec > 100)
                {
                    rt_printk("Instead of the short a long message %i has been received\n", n_rec);
                }
            }
            else
            {
                rt_printk("error receiving the second message:%i\n", n_rec);
            }

            
            // Reactivate the original timeout
            rt_dev_ioctl(sock, RTNET_RTIOC_TIMEOUT, &timeout_ns);

            // Send an acknowledge:
            //
            rc = rt_dev_sendto(sock, recvdata, ACKNOWLEDGESIZE, 0, 
                                (struct sockaddr *)&sockaddr_client, sockaddr_len);
            if (rc < 0)
            {
                rt_printk("Error rt_dev_send: %i\n", rc);
            }

        }
        else
        {
            if (data_received)
                rt_printk("Timeout n_rec:%i\n", n_rec);
            rt_sleep(100000);
        }

        /* Alive printout: */
        if (++loop % 100000 == 0)
        {
            rt_printk("Loop %u\n", loop);
        }
    }
            
        
}




/* *****************************************************************
 * ***************************************************************** */
int init_module(void)
{
    int rc;


    /* create rt-socket */
    sock=rt_dev_socket(AF_INET,SOCK_DGRAM,0);
    if (sock < 0)
    {
        rt_printk("Error creating rt_socket: %i\n", sock);
        goto ERROR_OUT;
    }

    rt_dev_ioctl(sock, RTNET_RTIOC_TIMEOUT, &timeout_ns);

    /* bind socket to local_addr */
    {
        unsigned long local_ip  = rt_inet_aton(local_ip_addr);
        struct sockaddr_in sockaddr;
        memset(&sockaddr, 0, sizeof(struct sockaddr_in));
        sockaddr.sin_family = AF_INET;
        sockaddr.sin_port = htons(udp_port);
        sockaddr.sin_addr.s_addr = local_ip;
        rc = rt_dev_bind(sock, (struct sockaddr *) &sockaddr, sizeof(struct sockaddr_in));
        if (rc)
        {
            rt_printk("rt_dev_bind: rc=%i\n", rc);
            goto ERROR_OUT;
        }
    }


    rt_set_oneshot_mode();
    start_rt_timer(0);
    
    rc = rt_task_init_cpuid(&server_task,(void *)server_process,0,4096,2,0,NULL, 0);
    if (rc)
    {
        rt_printk("Error: rt_task_init for data_process failed \n");
        goto ERROR_OUT;
    }

    

    rt_task_resume(&server_task);
    return 0;

ERROR_OUT:
    rt_printk("Error out\n");
    return 1;
}


void cleanup_module(void)
{
    if (sock >= 0)
    {
        rt_dev_close(sock);
    }
    rt_task_suspend(&server_task);
    rt_task_delete(&server_task);

    rt_printk ("cleanup_module done\n");
}


