#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <arpa/inet.h>
#include <linux/if.h>
#include <linux/if_ether.h>
#include <linux/if_packet.h>
#include <linux/net.h>

#include <native/task.h>
#include <rtnet.h>


/* Sequence:
 *
 * Client      Server
 *    -- 1472 -->
 *    --   32 -->
 *    <-- 800 ---
 * */


static int sock = -1;

static char *local_ip_addr = "192.168.8.3";
static char *server_ip_addr = "192.168.8.2";

static RT_TASK client_task;

static short udp_port = 22222;

static long long timeout_ns = 1000000000LL;  // 1s timeout

#define SENDDATASIZE 1472
static char data[SENDDATASIZE];

/**
 * The data process handles the realtime data from the rtos_comm module.
 * Once initialized, the data process does the job...
 * */
static void client_process(void *arg)
{
    int loop = 0;
    printf("client_process started\n");
    while (1)
    {
        int rc;
        int n_rec;

        strcpy(data, "long");
        rc = rt_dev_send(sock, data, SENDDATASIZE, 0);

        if (rc < 0)
        {
            printf("Error sending long message: %i\n", rc);
        }

        strcpy(data, "short");
        rc = rt_dev_send(sock, data, 32, 0);
        if (rc < 0)
        {
            printf("Error sending short message: %i\n", rc);
        }



        n_rec = rt_dev_recv(sock, data, SENDDATASIZE, 0);

        if (n_rec > 0)
        {
             // rt_printk("received %i\n", n_rec);

        }
        else
        {
            printf("Timeout n_rec:%i\n", n_rec);
            rt_task_sleep(100000);
        }

        if (++loop % 100000 == 0)
        {
            printf("Loop %u\n", loop);
        }
    }
}


void catch_signal(int sig)
{
    if (sock >= 0)
    {
        rt_dev_close(sock);
    }

    printf("catch_signal done\n");
}


/* *****************************************************************
 * ***************************************************************** */
int main()
{
    int rc;


    signal(SIGTERM, catch_signal);
    signal(SIGINT, catch_signal);
    signal(SIGHUP, catch_signal);
    mlockall(MCL_CURRENT|MCL_FUTURE);

    /* create rt-socket */
    sock=rt_dev_socket(AF_INET,SOCK_DGRAM,0);
    if (sock < 0)
    {
        printf("Error creating rt_socket: %i\n", sock);
        goto ERROR_OUT;
    }

    rt_dev_ioctl(sock, RTNET_RTIOC_TIMEOUT, &timeout_ns);

    /* bind socket to local_addr */
    {
        unsigned long local_ip  = inet_addr(local_ip_addr);
        struct sockaddr_in sockaddr;
        memset(&sockaddr, 0, sizeof(struct sockaddr_in));
        sockaddr.sin_family = AF_INET;
        sockaddr.sin_port = htons(udp_port);
        sockaddr.sin_addr.s_addr = local_ip;
        rc = rt_dev_bind(sock, (struct sockaddr *) &sockaddr, sizeof(struct sockaddr_in));
        if (rc)
        {
            printf("rt_dev_bind: rc=%i\n", rc);
            goto ERROR_OUT;
        }
    }

    /* Connect to server */
    {
        unsigned long server_ip  = inet_addr(server_ip_addr);
        struct sockaddr_in sockaddr;
        memset(&sockaddr, 0, sizeof(struct sockaddr_in));
        sockaddr.sin_family = AF_INET;
        sockaddr.sin_port = htons(udp_port);
        sockaddr.sin_addr.s_addr = server_ip;
        rc = rt_dev_connect(sock, (struct sockaddr *) &sockaddr, sizeof(struct sockaddr_in));
        if (rc)
        {
            printf("rt_dev_connect: rc=%i\n", rc);
            goto ERROR_OUT;
        }
    }


    rc = rt_task_spawn(&client_task, "client", 0, 10, 0, client_process, NULL);
    if (rc)
    {
        printf("Error: rt_task_init for data_process failed \n");
        goto ERROR_OUT;
    }

    pause();
    return 0;

ERROR_OUT:
    printf("Error out\n");
    return 1;
}
