package length;

import java.io.*;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;

import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.ResourceType;
import org.drools.conf.EventProcessingOption;

import org.drools.io.Resource;
import org.drools.io.ResourceFactory;

import org.drools.runtime.StatefulKnowledgeSession;

public class Main {

    private String compose( String... strings ){
	StringBuilder sb = new StringBuilder();
        for( String string: strings ){
	    sb.append( string ).append( "\n" );
	}
        return sb.toString();
    }

    private String makeDRL(){
        String s = compose(
            "package length",
            "",
	    "declare MyEvent",
	    "@role(event)",
            "end",
            "",

            "rule FaultsCoincide",
            "when",
            "    f1 : MyEvent( key == \"type1\" ) over window:length( 1 )",
            "    f2 : MyEvent( key == \"type2\" ) over window:length( 1 )",
            "then",
            "    System.out.println( \">>> f1=\" + f1 + \" f2=\" + f2 );",
            "    if( f1.getKey().equals( \"type2\" ) ) System.out.println( \"*** BUG ***\" );",
            "    if( f2.getKey().equals( \"type1\" ) ) System.out.println( \"*** BUG ***\" );",
            "end"

 );
        System.out.println( s );
        return s;
    }

    private StatefulKnowledgeSession makeSession(){
	KnowledgeBaseConfiguration kbConfig =
            KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbConfig.setOption( EventProcessingOption.STREAM );
	KnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase( kbConfig );
	StatefulKnowledgeSession kSession = kBase.newStatefulKnowledgeSession();
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String drl = makeDRL();
        Resource resource =
	    ResourceFactory.newReaderResource( new StringReader( drl ));
        kBuilder.add( resource, ResourceType.DRL );
	if( kBuilder.hasErrors() ) {
	    System.err.println( kBuilder.getErrors().toString() );
            throw new IllegalStateException( "### DRL errors ###" );
	}
        kBase.addKnowledgePackages( kBuilder.getKnowledgePackages() );
        return kBase.newStatefulKnowledgeSession();
    }

    public void runSession(){
        StatefulKnowledgeSession kSession = makeSession();

	MyEvent type1Alarm = new MyEvent( "type1" );
	System.out.println( "insert " + type1Alarm );
	kSession.insert( type1Alarm );
	kSession.fireAllRules();
	
	MyEvent type2Alarm = new MyEvent( "type2" );
	System.out.println( "insert " + type2Alarm );
	kSession.insert( type2Alarm );
	kSession.fireAllRules();
    }

    public static void main( String[] args ){
        Main m = new Main();
        m.runSession();
    }
}

