package com.paconsulting.drools.test;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Properties;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceFactory;

public class TestCompilation {

	private final static FileFilter RULES_FILES_FILTER = new FileFilter() {
		@Override
		public boolean accept(File pathname) {
			return pathname.getName().endsWith(".drl");
		}
	};
	
	private void testCompilation() throws FileNotFoundException, IOException {
		KnowledgeBuilderConfiguration configuration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder(configuration);

		File folder = new File("src/com/paconsulting/drools/test/");
		for (File file : folder.listFiles(RULES_FILES_FILTER)) {
			System.out.println("compiling "+file.getAbsolutePath());
			kbuilder.add(ResourceFactory.newFileResource(file.getAbsolutePath()), ResourceType.DRL);
		}
		
		System.out.println("saving");
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("test.drl.compiled"));
        out.writeObject( kbuilder.getKnowledgePackages());
        out.close();
	}
	
	private KnowledgeBase testLoad() throws FileNotFoundException, IOException, ClassNotFoundException {
		Properties configProperties = new Properties();
		KnowledgeBaseConfiguration knowledgeBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(configProperties);
		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase(knowledgeBaseConfiguration);
		
		ObjectInputStream in = new ObjectInputStream(new FileInputStream("test.drl.compiled"));

		System.out.println("loading");
		kbase.addKnowledgePackages((Collection<KnowledgePackage>) in.readObject());
		in.close();
		
		return kbase;
	}
	
	public static void main(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException {
		TestCompilation testCompilation = new TestCompilation();
		testCompilation.testCompilation();
		testCompilation.testLoad();
	}
}
