from numpy import zeros

def updateGhost(u_n, v_n, uT, uB, vL, vR):
    
    u_np = zeros(u_n.shape, float)
    v_np = zeros(v_n.shape, float)    
    
    u_np = u_n
    v_np = v_n
    
    u_np[0,:]    = uB.T*2. - u_n[1,:];  # Bottom ghost velocities
    u_np[-1,:]   = uT.T*2. - u_n[-2,:]; # Top ghost velocities
    
    v_np[:,0]    = vL.T*2. - v_n[:,1];  # Left ghost velocities
    v_np[:,-1]   = vR.T*2. - v_n[:,-2]; # Right ghost velocities
    
    return u_np, v_np