#===============================================================================
#
# Created by    : C.F. Baptista BSc.
# Created on    : 04/10/2011
# Modified on   : 05/10/2011
#
#===============================================================================
#
# meshGen
#
# This script generates either an uniform or a non-uniform 2D grid consisting
# out of either square or rectangular cells.
#
#===============================================================================

from numpy import linspace, zeros, array, insert, append

def uniMesh(N):
    
    nodes      = zeros([2,N+1], float)
    nodes[0,:] = linspace(0, 1, N+1)
    nodes[1,:] = linspace(0, 1, N+1)
    
    [dx, dy]   = computeFace(nodes, N)
    
    return nodes, dx, dy

def nonUniMesh(N):

    return
    
def computeFace(nodes, N):
    
    ds = array(nodes[0,1:] - nodes[0,:-1])
    ds = insert(ds, 0, ds[0])
    ds = append(ds, ds[-1])
    
    dx = zeros([N+2,N+2], float)
    for i in range(0,N+2):
        dx[i,:] = ds
        
    ds = array(nodes[1,1:] - nodes[1,:-1])
    ds = insert(ds, 0, ds[1])
    ds = append(ds, ds[-1])
    
    dy = zeros([N+2,N+2], float)
    for i in range(0,N+2):
        dy[i,:] = ds
    
    return dx, dy