# Copyright 1999-2009 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

inherit eutils toolchain-funcs multilib

DESCRIPTION="A GTK+ language binding for the librep Lisp environment"
HOMEPAGE="http://rep-gtk.sourceforge.net/"
SRC_URI="mirror://sourceforge/rep-gtk/${P}r2.tar.bz2"

S="${WORKDIR}/${P}r2"

LICENSE="GPL-2"
SLOT="gtk-2.0"
KEYWORDS="amd64"

RDEPEND=">=dev-libs/librep-0.17.3
	>=x11-libs/gtk+-2.6"
DEPEND="${RDEPEND}
	dev-util/pkgconfig"

src_unpack() {
		unpack ${A}
		cd "${S}"
}

src_compile() {
econf \
		--prefix=/usr || die "configure failed"
	emake || die "make failed"
}

src_install() {
	make DESTDIR="${D}" install || die "make install failed"

	dodoc AUTHORS BUGS ChangeLog HACKING NEWS README* TODO
	docinto examples
	dodoc examples/*
}
