/* Demonstrate serial RS-232 communication via the 8251 UART/USART*/

// A simple demonstration of the 8251 UART connected to the MIPS
// system bus. This program just transmits a welcome message, and
// then starts to send out a counter value...
// TinyMips doesn't support interrupts (yet), so polling is used.
// Remember that nCTS must be kept low to enable the transmitter
// of the UART 8251.



// axxx.xxxx would be mapped to 0xxx.xxxx by the (static) MMU,
// but we have disabled the MMU. So, the addresses are unchanged.
// 
#import "uart.h"
#import <z80/types.h>
#import <typeof.h>

sfr at 0xf4 UART_DATA;
sfr at 0xf5 UART_CMD;




static int* global;


void reset(void)
   
{   
       UART_CMD =  UART_0STOP;
        UART_CMD =  UART_0STOP;
        UART_CMD =  UART_0STOP;
        UART_CMD =UART_IR;
        
}
/*
 * re-configures the UART to the given parameters in async mode
 */
void
uartAsyncMode(int value)
{

        // 
        // assuming we don't know the exact status of the UART 8251,
        // it might be in its internal WAIT_FOR_SYNC_1_AND_2 state.
        // Therefore, the first two write operations might end up as data
        // in the SYNC1 and SYNC2 data registers. But the third write 
        // operation is guaranteed to be decoded as an internal-reset command
        // which re-initializes the 8251 to expect a mode command next.
        // 
       // UART_CMD = UART_IR;
       // UART_CMD = UART_IR;
       // UART_CMD = UART_IR;
        // now, we can write the mode command requested by the user.
        //
	UART_CMD =  UART_0STOP;
        UART_CMD =  UART_0STOP;
        UART_CMD =  UART_0STOP;
        UART_CMD =UART_IR;
        UART_CMD = value & 0xff;
}

void
uartAsync8N2_X1()
{
        uartAsyncMode(UART_2STOP | UART_NO_PARITY | UART_8BITS | UART_X1);
}

/*
 * write the given data value to the command register. 
 * The user is responsible to provide sensible data values here.
 * Also, there is no way to check that the UART is actually expecting
 * a command. 
 */
void
uartCommand(int value)
{
        UART_CMD = value & 0xff;
}

/*
 * write the value UART_CMD_ER or 0x10 to the 8251 in command mode,
 * that is, CnD=1. This resets the receiver error status flags when
 * the 8251 is in command mode (but no check is made to ensure that
 * this is actually the case).
 */
void
uartResetErrors()
{
        uartCommand(UART_ER);
}

/*
 * write the given data character to the transmit buffer of the 8251.
 * It is the user's responsibility to check that the 8251 is ready
 * to accept a new data character (i.e., transmitter is enabled and
 * TXEMPTY).
 * Actual transmission might be delayed until nCTS is asserted low.
 */
void
uartSendData(char c)
{
        UART_DATA = c & 0xff;
}

/**
 * reads the 8251 status register. 
 * See the datasheet for the meaning of the individual bits.
 * Note that SYNDET/BD always reads zero, because the Hades simulation
 * model of the 8251 does not yet support break-detect or sync mode.
 */
int
uartReadStatus()
{
        //  int *uart = (int*) UART_DATA;
        int tmp = 0;
        tmp = UART_CMD;
        //  tmp = *(uart+1);

        // *(uart+1) = 0x87;
        return tmp;
}

/* returns the error flags, or 0 if no errors set. */
int
uartHasError()
{
        int status = uartReadStatus();
        int mask = (UART_FE | UART_OE | UART_PE);
        return (status & mask) == 0;
}

int
uartIsRXRDY()
{
          int status =  UART_CMD;
        int mask = UART_RXRDY;
        return (status & mask) == UART_RXRDY;
}

int
uartIsTXRDY()
{
         int status =  UART_CMD;
        int mask = UART_TXRDY;
        return (status & mask) == UART_TXRDY;
}

int
uartIsTXEMPTY()
{
        int status =  UART_CMD;
        int mask = UART_TXEMPTY;
        return (status & mask) == UART_TXEMPTY;
}

char
uartReadData()
{
        char tmp;
        int uart = UART_DATA;

        tmp = (uart) & 0xff;
        return tmp;
}

void
uartSendDataPolling(char c)
{
       while (!uartIsTXEMPTY()) ;
       
        uartSendData(c);
}

char
hex(int digit)
{
        digit = digit & 0xf;
        if (digit <= 9) return ('0' + digit);
        else return ('a' + digit - 10);
}

void sayHello()
{
        uartSendDataPolling(0x0a);
        uartSendDataPolling(0x0d);
        uartSendDataPolling('H');
        uartSendDataPolling('e');
        uartSendDataPolling('l');
        uartSendDataPolling('l');
        uartSendDataPolling('o');
        uartSendDataPolling(',');
        uartSendDataPolling(' ');
        uartSendDataPolling('w');
        uartSendDataPolling('o');
        uartSendDataPolling('r');
        uartSendDataPolling('l');
        uartSendDataPolling('d');
        uartSendDataPolling('!');

       
}

