/* 
 * File:   uart.h
 * Author: crodrigu
 *
 * Created on November 8, 2008, 12:00 PM
 */

#ifndef _UART_H
#define	_UART_H

#ifdef	__cplusplus
extern "C" {
#endif

    // mode register bits
    // 
#define UART_STOP_MASK   0xc0
#define UART_2STOP       0xc0
#define UART_15STOP      0x80
#define UART_1STOP       0x40
#define UART_0STOP       0x00    // invalid

#define UART_PARITY_MASK 0x30
#define UART_EVEN_PARITY 0x20
#define UART_ODD_PARITY  0x10
#define UART_NO_PARITY   0x00

#define UART_BITS_MASK   0x0c
#define UART_8BITS       0x0c
#define UART_7BITS       0x08
#define UART_6BITS       0x04
#define UART_5BITS       0x00

#define UART_PRESCALER   0x03
#define UART_X64         0x03
#define UART_X16         0x02
#define UART_X1          0x01
#define UART_SYNC_MODE   0x00    // not implemented


    // command register bits
    // 
#define UART_EH          0x80    // enter hunt-mode: not implemented
#define UART_IR          0x40    // internal reset
#define UART_RTS         0x20    // 1: nRTS=0  0: nRTS=1
#define UART_ER          0x10    // reset error flags in status register
#define UART_SBRK        0x08    // send break, forces TXD low
#define UART_RXE         0x04    // receiver enable bit
#define UART_DTR         0x02    // 1: nDTR=0  1: nDTR=1
#define UART_TXE         0x01    // transmitter enable bit


    // status register bits
    // 
#define UART_DSR         0x80   // data set ready
#define UART_SYNDET_BD   0x40   // sync detected
#define UART_FE          0x20   // framing error
#define UART_OE          0x10   // overrun error
#define UART_PE          0x08   // parity error
#define UART_TXEMPTY     0x04   // tx empty
#define UART_RXRDY       0x02   // rx ready
#define UART_TXRDY       0x01   // tx ready


    void reset(void);
    void uartAsyncMode(int value);
    void uartAsync8N2_X1();
    void uartCommand(int value);
    void uartResetErrors();
    void uartSendData(char c);
    int uartReadStatus();
    int uartHasError();

    int uartIsRXRDY();
    int uartIsTXRDY();

    int uartIsTXEMPTY();

    char uartReadData();

    void uartSendDataPolling(char c);

    char hex(int digit);
    void sayHello();

#ifdef	__cplusplus
}
#endif

#endif	/* _UART_H */

