#include <stdio.h>


/* In my homemade Z80, these addresses in RAM are jumps to addresses in the 
bios (EPROM) where the actual routines are implemented. */
#define SerialPutChar 0x7ff0
#define SerialGetChar 0x7feC

/* The main block is put here since SDCC will put main.o first when linking. 
So, other code within main.c must go after int main(). Another way to do this 
is to put routines into another file and add it to the project. */

int main (void)
{
	printf("Hello World from SDCC, using codeblocks on linux\n");
	return 0;
}

/* Defining putchar and getchar allows us to use printf. */

void putchar(char c)
{
_asm
        ld      a,4(ix)
        call    SerialPutChar
_endasm;
}

char getchar(void)
{
_asm
        call    SerialGetChar
        ld      l,a
_endasm;
}


