/*
    temete.c
    Nstor Amigo Cairo - nestorac@gmail.com
    05 Jan 2009
    
    The code for the TMT System. Precautions should be taken on using it
    or you can get burnt!!
*/

#include "temete2.h"
#include "temete3.h"
#include "temete4.h"

#include <pic14regs.h>

BYTE totaltime[]={1,30};
BYTE language=I18N_ES;
BYTE count_down[]={0xff,COUNTER_HIGH};

/* Setup chip configuration */
typedef unsigned int config;
config at 0x2007 __CONFIG = _CP_OFF & 
                          _WDT_OFF & 
                          _BODEN_OFF & 
                          _PWRTE_OFF &
                          _HS_OSC &
                          _LVP_OFF &
                          _WRT_ENABLE_OFF;


static void Pantini(void)
{
  //BYTE i;
  
	PORTD = 0xf0;   /* WR, RD, CE, CMD */
	PORTC = 0x01;   /* FS */
	
	RC5 = 0;        /* Reset */
	
	Pause();
	
	RC5 = 1;         /* Reset off */
	
	PauseLong();
	
	dt2(0,0);
	cmd(TXHOME);    /* Text home address 0x0000 */
	dt2(2,128);
	cmd(GRHOME);    /* Set graphic home address 0x280 */
	dt2(0,0x28);
	cmd(TXAREA);    /* Text area: 40 col 6x8 */
	dt2(0,0x28);
	cmd(GRAREA);    /* Graphic area: 40 col */
	cmd(MODE_EXOR); /* Modeset (XOR mode, internal character gen mode) */
	cmd(DISP_GR_ON_TXT_ON);      // Text on, graphics on
	Borrar();
}


void PaintClockTest(BYTE x, BYTE y)
{
  BYTE i = 0;
  /*
	// We paint the border
	
  for (i = 1; i <= 6; i++)
  {
    PaintChar(128+i-1, x+i, y+1, MODE_EXOR);
	}
	
	PaintChar(134, x+1, y+2, MODE_EXOR);
	PaintChar(135, x+6, y+2, MODE_EXOR);
	PaintChar(136, x+1, y+3, MODE_EXOR);
	PaintChar(137, x+6, y+3, MODE_EXOR);
	
  for (i = 1; i <= 6; i++)
  {
    PaintChar(137+i, x+i, y+4, MODE_EXOR);
	}
	
	// And also the inner blank space:
	
  for (i = 2; i <= 5; i++)
  {
    PaintChar(0, x+i, y+2, MODE_EXOR);
	}
  for (i = 2; i <= 5; i++)
  {
    PaintChar(0, x+i, y+3, MODE_EXOR);
	}
	
	PauseQuarterSecond();
  	
  while(TRUE)
  {
  	// Now, we paint the inner 1st quarter of the clock:
  	PaintChar(147, x+4,y+1, MODE_EXOR);
  	PaintChar(148, x+5,y+1, MODE_EXOR);
  	PaintChar(149, x+6,y+1, MODE_EXOR);
  	PaintChar(160, x+4,y+2, MODE_EXOR);
  	PaintChar(160, x+5,y+2, MODE_EXOR);
  	PaintChar(151, x+6,y+2, MODE_EXOR);
  	
  	PauseQuarterSecond();
  	
  	// Now, we show the 2nd:  	
  	PaintChar(160, x+4,y+3, MODE_EXOR);
  	PaintChar(160, x+5,y+3, MODE_EXOR);
  	PaintChar(153, x+6,y+3, MODE_EXOR);
  	PaintChar(157, x+4,y+4, MODE_EXOR);
  	PaintChar(158, x+5,y+4, MODE_EXOR);
  	PaintChar(159, x+6,y+4, MODE_EXOR);
  	
  	PauseQuarterSecond();
  	
  	// Now, we show the 3rd:  	
  	PaintChar(152, x+1,y+3, MODE_EXOR);
  	PaintChar(160, x+2,y+3, MODE_EXOR);
  	PaintChar(160, x+3,y+3, MODE_EXOR);
  	PaintChar(154, x+1,y+4, MODE_EXOR);
  	PaintChar(155, x+2,y+4, MODE_EXOR);
  	PaintChar(156, x+3,y+4, MODE_EXOR);
  	
  	PauseQuarterSecond();
  	
  	// Now, we show the 4th:  	
  	PaintChar(144, x+1,y+1, MODE_EXOR);
  	PaintChar(145, x+2,y+1, MODE_EXOR);
  	PaintChar(146, x+3,y+1, MODE_EXOR);
  	PaintChar(150, x+1,y+2, MODE_EXOR);
  	PaintChar(160, x+2,y+2, MODE_EXOR);
  	PaintChar(160, x+3,y+2, MODE_EXOR);
  	
  	PauseQuarterSecond();
  	
  
  	// We clean the 1st quarter
  	
    for (i = 4; i <= 6; i++)
    {
      PaintChar(128+i-1, x+i, y+1, MODE_EXOR);
  	}
    PaintChar(  0, x+4, y+2, MODE_EXOR);
    PaintChar(  0, x+5, y+2, MODE_EXOR);
  	PaintChar(135, x+6, y+2, MODE_EXOR);
  	
  	PauseQuarterSecond();
  	
  	// We clean the 2nd quarter
  	
    PaintChar(  0, x+4, y+3, MODE_EXOR);
    PaintChar(  0, x+5, y+3, MODE_EXOR);
  	PaintChar(137, x+6, y+3, MODE_EXOR);
  	
    for (i = 4; i <= 6; i++)
    {
      PaintChar(137+i, x+i, y+4, MODE_EXOR);
  	}
  	
  	PauseQuarterSecond();
  	
  	// We clean the 3rd quarter
  	
    for (i = 1; i <= 3; i++)
    {
      PaintChar(137+i, x+i, y+4, MODE_EXOR);
  	}
  	
  	PaintChar(136, x+1, y+3, MODE_EXOR);
    PaintChar(  0, x+2, y+3, MODE_EXOR);
    PaintChar(  0, x+3, y+3, MODE_EXOR);
  	
  	PauseQuarterSecond();
  	
  	// We finally clean the 4th quarter
  	
    for (i = 1; i <= 3; i++)
    {
      PaintChar(128+i-1, x+i, y+1, MODE_EXOR);
  	}
  	
  	PaintChar(134, x+1, y+2, MODE_EXOR);
    PaintChar(  0, x+2, y+2, MODE_EXOR);
    PaintChar(  0, x+3, y+2, MODE_EXOR);
  	
  	PauseQuarterSecond();
	}
	*/
	
	
	//PaintChar(128, 1, 1);
	
}


void Menu()
{
  PrintLineAlign("RADIOFREQUENCY SYSTEM", 2, ALIGN_CENTER, NORMAL);
  
  PrintLineAlignXYI18n(I18N_TOTAL_TIME_H, I18N_TOTAL_TIME_L, 16, 5, ALIGN_RIGHT, NORMAL);
  PrintLineAlignXY("01'30\"", 16, 7, ALIGN_RIGHT, MODE_EXOR);
  
  PrintLineAlignXYI18n(I18N_SPOT_TIME_H, I18N_SPOT_TIME_L, 16, 10, ALIGN_RIGHT, NORMAL);
  PrintLineAlignXY("15\"", 16, 12, ALIGN_RIGHT, MODE_EXOR);
  
  PrintLineAlignXYI18n(I18N_POWER_H, I18N_POWER_L, 26, 5, ALIGN_LEFT, NORMAL);
  PrintLineAlignXY("75%", 26, 7, ALIGN_LEFT, MODE_EXOR);

  
  PrintHorizStrike();
  DrawIcons();
}

static void Intr(void) __interrupt 0
{
  BYTE result;
  
  //if (T0IF)
  //{
    result = CountDecrement();
    if (!result)
    {
      result = TimeDecrement();
      if (!result)
      {
        // The treatment has ended.
        T0IE = 0; // Disable the countdown;
      }
      else
      {
        PrintTime();
      }
    }
  //}
  
  T0IF = 0;
}

static void init_system()
{
    GIE = 1;         /* Enable global interrupts */
    PEIE = 1;        /* Enable peripheral interrupts */

    PS0 = 1;        // option register b'111'
    PS1 = 1;
    PS2 = 1;

    T0CS = 0;    /* Source of timer0 is instruction clock */
    T0SE = 0;    /* Increment timer0 on low-to-high transition */
    PSA = 1;     /* Prescaler assigned to the watchdog */
    TMR0 = 0;                   /* clear timer0 */
}


void main(void) {
    
    /* Assign input/output state to tristates */     
    TRISA = A_OUTPUTS;
    TRISB = B_OUTPUTS;
    TRISC = C_OUTPUTS;
    TRISD = D_OUTPUTS;
    TRISE = E_OUTPUTS;
    /* Initialize ports */
    PORTA=0;
    PORTB=0;
    PORTC=0;
    PORTD=0;
    PORTE=0;
    
    
    Beep(BEEP_START);
    Pantini();
    init_system();
    Menu();
    
    T1CON = 0x21;
    T2CON = 0x06;
    PR2 = 0xff;
    CCP2CON = 0x0c;
    CCPR2L = 0x30;
    
    /*
    // Timer 2
    PR2=0xff;   // 4 MHz clock -> 5kHz PWM frequency
    T2CON = (1<<TMR2ON);

    // Initialize Control PWM
    CCPR2L  = 30;    // Initial Duty
    CCP2CON = 0x0f;  // PWM mode set and 5,4 duty = 0
    */
    Beep(BEEP_END);
    testEncoder();
    while(1);
}
