#include "temete3.h"
#include "temete4.h"

BYTE getValueMesoestetic(BYTE value, BYTE pos)
{
  return(0);
}


void PaintGfxMesoestetic(BYTE x, BYTE y)
{
  BYTE i, line, repeat, column;
  
  column = 0;
  
  for (column = 0; column <=17; column++)
  {
    line = 1;
    for (i = 0; i <12; i++)
    {
      repeat = 0;
      // While repeat is less than the two MSB's of gfx[i-1] do:
      while ( repeat <= ( (getValueMesoestetic(column, i)>>6) & 0x03 ) )
      {
        PaintScanLine((getValueMesoestetic(column, i) & 0x3f), x+column, line + repeat + y-1);
        repeat++;
      }
      line += repeat;
    }
  }
}


void PrintLineAlign(BYTE* text, BYTE y, BYTE align, TStyle style)
{
  BYTE lenght;
  
  lenght = 0;
  
  while (text[lenght] != 0)
  {
    if (lenght == 255)
    {
      BeepError(ERROR_LINEEND); // Error. There is no line end.
    }
    lenght++;
  }
  
  if ((lenght > 40) || (lenght < 1))
  {
    BeepError(ERROR_TEXTLENGTH);     // Error. Text must be between 1 and 40 characters long.
  }
  
  if (align == ALIGN_LEFT)
  {
    PrintLine(text, 1, y, style);
  }
  else if (align == ALIGN_RIGHT)
  {
    PrintLine(text, 40-(lenght-1), y, style);
  }
  else if (align == ALIGN_CENTER)
  {
    PrintLine(text, ((40-(lenght-1)) >> 1)+1, y, style);
  }
}


void PrintLineAlignXY(BYTE* text, BYTE x, BYTE y, BYTE align, TStyle style)
{
  BYTE size=0;
  if (align == ALIGN_LEFT)
  {
    PrintLine(text, x, y, style);
  }
  else
  {
    for (size=0; text[size]!=0; size++);
    if (align == ALIGN_CENTER)
    {
      PrintLine(text, x-(size/2), y, style);
    }
    else if (align == ALIGN_RIGHT)
    {
      PrintLine(text, x-size, y, style);
    }
    else
    {
      // ERROR
    }
  }
}


// PrintLineAlignXYI18n - Prints a line at some coordinates with a specific
//                        alignment for the current language
// addH, addrL: Address High, Low
// x, y:        LCD Screen position
// align:       Alignment (Left, Center, Right)
// style:       Style (AND, OR, EXOR mode)

void PrintLineAlignXYI18n(BYTE addrH, BYTE addrL, BYTE x, BYTE y, BYTE align, TStyle style)
{
  BYTE aux=0, i=0, spaces=0;
  BYTE text[]={0xff,0};
  
  SerialSetAddr(addrH, addrL);
  
  // This reads memory until it gets to the correct language.
  
  for (i=0; i!=language; i++)
  {
    while (text[0] != 0)
    {
      text[0] = SerialReadPostIncr();
    }
    text[0] = SerialReadPostIncr();
  }
  
  if (language == I18N_ES)
  {
    text[0] = SerialReadPostIncr();
  }
  
  i = 0;
  
  // This reads memory to print the characters for the proper language.
  if (align == ALIGN_LEFT)
  {
    while (i <= 40)
    {
      //text[0] = SerialReadPostIncr();
      if ((text[0] == 0) || (text[0] == 0xff))
      {
        return;
      }
      PrintLine(text, x+i, y, style);
      i++;
      text[0] = SerialReadPostIncr();
    }
  }
  else if (align == ALIGN_RIGHT)
  {
    aux = SerialReadPostIncr();
    while ( (aux != 0) && (aux != 0xff) )
    {
      if (aux == 0x20)
      {
        spaces++;
      }
      else
      {
        spaces = 0;
      }
      aux = SerialReadPostIncr();
      i++;
    }
    SerialReadPostDecr();
    // We skip the spaces.
    if (spaces != 0)
    {
      while (SerialReadPostDecr() == 0x20)
      SerialReadPostIncr();
    }
    aux = 0;
    // We print the characters from memory, backwards.
    while ( aux < (i - spaces) )
    {
      text[0] = SerialReadPostDecr();
      PrintLine(text, x-aux, y, style);
      aux++;
    }
    text[0]=0x20;
    // Now, we print the spaces.
    while ( spaces > 0 )
    {
      PrintLine(text, x-i+spaces, y, style);
      spaces--;
    }
  }
  
  // TODO: Implement cases where align != ALIGN_LEFT
  
  /*
  else
  {
    for (size=0; text[size]!=0; size++);
    if (align == ALIGN_CENTER)
    {
      PrintLine(text, x-(size/2), y, style);
    }
    else if (align == ALIGN_RIGHT)
    {
      PrintLine(text, x-size, y, style);
    }
    else
    {
      // ERROR
    }
  }
  */
}


void DrawMenuItemIcon(BYTE x, BYTE y, BYTE width, BYTE height, bool delete)
{
  BYTE i, offset_l, offset_r, col_l, col_r, mask;
  
  if (delete)
  {
    mask = 0x00;
  }
  else
  {
    mask = 0xff;
  }
  
  col_l = (x/6)+1;
  col_r = (x+width)/6;
  offset_l = x%6;
  offset_r = (x+width)%6;
  
  PaintScanLine(31 & mask, col_l, y);
  PaintScanLine(31 & mask, col_l, y+height);
  PaintScanLine(62 & mask, col_r, y);
  PaintScanLine(62 & mask, col_r, y+height);
  
  PaintScanLine(32 & mask, col_l, y+2);
  PaintScanLine(32 & mask, col_l, y+height-2);
  PaintScanLine( 1 & mask, col_r, y+2);
  PaintScanLine( 1 & mask, col_r, y+height-2);
  
  for (i=col_l+1; i<col_r; i++)
  {
    PaintScanLine(63 & mask, i, y);
    PaintScanLine(63 & mask, i, y+height);
  }
  
  for (i=col_l; i<=col_r; i++)
  {
    PaintScanLine(63 & mask, i, y+1);
    PaintScanLine(63 & mask, i, y+height-1);
  }
  
  
}


void DrawIcons()
{
  DrawIcon(ADDR_STOP_H, ADDR_STOP_L, 1, 109, ICON_GREY);
  DrawIcon(ADDR_PLAY_H, ADDR_PLAY_L, 6, 109, ICON_NORMAL);
  DrawIcon(ADDR_LANGES_H, ADDR_LANGES_L, 11, 109, ICON_NORMAL);
  DrawIcon(ADDR_SOUNDON_H, ADDR_SOUNDON_L, 16, 109, ICON_NORMAL);
  DrawIcon(ADDR_BODY_H, ADDR_BODY_L, 26, 109, ICON_NORMAL);
  DrawIcon(ADDR_FACE_H, ADDR_FACE_L, 31, 109, ICON_GREY);
  DrawIcon(ADDR_TRANSFER_H, ADDR_TRANSFER_L, 36, 109, ICON_GREY);
}


BYTE getValueClock(BYTE value, BYTE pos)
{
  return(0);
}


//void setCustomChar(BYTE value)
void setCustomChar(BYTE addr1, BYTE addr2, BYTE value)
{
  cmd(MODE_OR); // OR Mode
  dt2(addr1, addr2);
	cmd(ADPSET);
  dt1(value);
	cmd(0xc4); // Write data and not change ADP
}


static BYTE getValueAddr1(BYTE input_i)
{
  if (input_i > 31)
  {
    return 253;
  }
  else
  {
    return 252;
  }
}


static BYTE getValueAddr2(BYTE input_i, BYTE input_j)
{
  if (input_i > 31)
  {
    input_i -= 32;
  }

  return (input_i*8 + input_j);
}


void setCustomCharacters()
{
  
  BYTE i = 0, j = 0;
  
  //dt2(0xfc, 00);
  for (i=0; i<33; i++)
  {
    for (j=0; j<8; j++)
    {
      setCustomChar(getValueAddr1(i), getValueAddr2(i,j), getValueClock(i, j));
    }
  }
}


bool TimeDecrement()
{
  if ((totaltime[1] == 1) && (totaltime[0] == 0))
  {
    return FALSE;
  }
  
  if (totaltime[1] > 0)
  {
    totaltime[1]--;
  }
  else if (totaltime[0] > 0)
  {
    totaltime[0]--;
    totaltime[1] = 59;
  }
  else
  {
    return FALSE;
  }
  return TRUE;
}


bool TimeIncrement()
{
  return TRUE;
}
