/*
    temete2.c
    Ricardo L. Febrero <rlfebrero@gmail.com>
    
    See COPYING for more details on the license.
    (c) April 2009
    
    Precautions should be taken on using it or you can get burnt!!
*/


#include "temete2.h"
#include "temete3.h"


// PaintScanLine: Paints a line in column x, file y (6 bits)
//                x: a column, 6 bits width
//                y: a line, 1 bit width

extern BYTE language;
extern BYTE totaltime[2];
extern BYTE count_down[2];


void PaintMask(BYTE pattern[8], BYTE x, BYTE y, BYTE mask[8])
{
  BYTE i;
  
  for (i=0; i<8; i++)
  {
    pattern[i] -= mask[i];
  }
  
  Paint(pattern, x, y);
}


void PrintLine(BYTE* text, BYTE x, BYTE y, TStyle style)
{
  BYTE i, hh, ll;
  BYTE pattern[8] = {0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f};
  BYTE mask[8] = {0x5, 0xa, 0, 0, 0, 0, 0, 0};
  
  hh = 0;
  ll = 0;
  
  //hh = 0; // The output is text.
  
  if ((x > 40) || (y > 16) || (x == 0) || (y == 0))
  {
    BeepError(ERROR_TEXTPOS);
  }
  
  if ((y < 7) || ((y == 7) && (x < 17)))
  {
    ll = (y-1)*40+x-1;
  }
  else if ((y < 13) || ((y == 13) && (x < 33)))
  {
    hh = 1;
    ll = 40*(y-7)+x-17;
  }
  else
  {
    hh = 2;
    ll = 40*(y-13)+x-33;
  }
  
  i = 0;
  if (style == INVERTED)
  {
    while (text[i] != 0)
    {
      Paint(pattern, x+i, y);
      i++;
    }
  }
  
  i = 0;
	dt2(hh,ll);
	cmd(ADPSET);
	cmd(AWRON);
  while (text[i] != 0)
  {
    if (text[i] < 0x80)
    {
      dt1(text[i]-0x20);
    }
    else
    {
      switch (text[i])
      {
        case 0xe7:    // 'ç'
          dt1(0x60);
          break;
        case 0xf1:     // 'ñ'
          cmd(AWROFF);
          PaintMask(pattern, x+i, y, mask);
	        dt2(hh,ll+i);
	        cmd(ADPSET);
          cmd(AWRON);
          dt1(0x4e);
          break;
      }
    }
    i++;
  }
	cmd(AWROFF);
}


void PrintHorizStrike()
{
  BYTE i, j;

  for (i=0; i<3; i++)
  {
    for (j=1; j<=40; j++)
    {
      PaintScanLine(63, j, 20+i);
    }
  }
  
  for (i=0; i<3; i++)
  {
    for (j=1; j<=40; j++)
    {
      PaintScanLine(63, j, 102+i);
    }
  }
}


bool goesUp(BYTE last, BYTE current)
{
  if (last == 2 && current == 0)
  {
    return FALSE;
  }
  else if (last == 3 && current == 2)
  {
    return FALSE;
  }
  else if (last == 1 && current == 3)
  {
    return FALSE;
  }
  else if (last == 0 && current == 1)
  {
    return FALSE;
  }
  else
  {
    return TRUE;
  }
  return TRUE;
}


void DrawMenuItem(bool delete)
{  
  switch (menu_option)
  {
    case ITEM_STOP:
      DrawMenuItemIcon(2, 106, 28, 20, delete);
      break;
    case ITEM_START:
      DrawMenuItemIcon(32, 106, 28, 20, delete);
      break;
    case ITEM_LANG:
      DrawMenuItemIcon(62, 106, 28, 20, delete);
      break;
    case ITEM_SND:
      DrawMenuItemIcon(92, 106, 28, 20, delete);
      break;
    case ITEM_BODY:
      DrawMenuItemIcon(153, 106, 27, 20, delete);
      break;
    case ITEM_FACE:
      DrawMenuItemIcon(183, 106, 27, 20, delete);
      break;
    case ITEM_TRANSF:
      DrawMenuItemIcon(213, 106, 27, 20, delete);
      break;
    case ITEM_TTIME:
      DrawMenuItemIcon(61, 44, 36, 15, delete);
      break;
    case ITEM_STIME:
      DrawMenuItemIcon(79, 84, 18, 15, delete);
      break;
    case ITEM_POW:
      DrawMenuItemIcon(151, 44, 18, 15, delete);
      break;
    default:
      break;
  }
}


void ExecuteMenuItem(bool isPressed)
{
  if (selected_item == 255)
  {
    if (isPressed)
    {
    }
    else
    {
	    PaintHex(menu_option, 1, 12, NORMAL);
  	  PaintHex(ITEM_TRANSF, 1, 13, NORMAL);
      if ((ITEM_TRANSF < menu_option) || ((menu_option < ITEM_BODY) && (menu_option != ITEM_LANG) &&
         (menu_option != ITEM_START)))
      {
        PrintLineAlign("Ok.", 1, ALIGN_RIGHT, NORMAL);
        selected_item = menu_option;
      }
      else
      {
        switch (menu_option)
        {
          case ITEM_START:
            T0IE = 1;     // Enable the countdown
            break;
          case ITEM_LANG:
            language++;
            language%=3;
            
            PaintHex(language, 20, 9, NORMAL);
            
            PrintLineAlignXYI18n(I18N_TOTAL_TIME_H, I18N_TOTAL_TIME_L, 16, 5, ALIGN_RIGHT, NORMAL);
            PrintLineAlignXYI18n(I18N_SPOT_TIME_H, I18N_SPOT_TIME_L, 16, 10, ALIGN_RIGHT, NORMAL);
            PrintLineAlignXYI18n(I18N_POWER_H, I18N_POWER_L, 26, 5, ALIGN_LEFT, NORMAL);
            break;
          case ITEM_BODY:
            if (treatment == TREAT_FACE)
            {
              DrawIcon(ADDR_FACE_H, ADDR_FACE_L, 31, 109, ICON_GREY);
            }
            else if (treatment == TREAT_TRANS)
            {
              DrawIcon(ADDR_TRANSFER_H, ADDR_TRANSFER_L, 36, 109, ICON_GREY);
            }
            else
            {
              break;
            }
            treatment = TREAT_BODY;
            DrawIcon(ADDR_BODY_H, ADDR_BODY_L, 26, 109, ICON_NORMAL);
            break;
            
          case ITEM_FACE:
            if (treatment == TREAT_BODY)
            {
              DrawIcon(ADDR_BODY_H, ADDR_BODY_L, 26, 109, ICON_GREY);
            }
            else if (treatment == TREAT_TRANS)
            {
              DrawIcon(ADDR_TRANSFER_H, ADDR_TRANSFER_L, 36, 109, ICON_GREY);
            }
            else
            {
              break;
            }
            treatment = TREAT_FACE;
            DrawIcon(ADDR_FACE_H, ADDR_FACE_L, 31, 109, ICON_NORMAL);
            break;
            
          case ITEM_TRANSF:
            if (treatment == TREAT_FACE)
            {
              DrawIcon(ADDR_FACE_H, ADDR_FACE_L, 31, 109, ICON_GREY);
            }
            else if (treatment == TREAT_BODY)
            {
              DrawIcon(ADDR_BODY_H, ADDR_BODY_L, 26, 109, ICON_GREY);
            }
            else
            {
              break;
            }
            treatment = TREAT_TRANS;
            DrawIcon(ADDR_TRANSFER_H, ADDR_TRANSFER_L, 36, 109, ICON_NORMAL);
            break;
          default:
            break;
        }
      }
    }
  } // IF (selected_item != 255)
  else
  {
    if (isPressed)
    {
    }
    else
    {
      selected_item = 255;
      PrintLineAlign("   ", 1, ALIGN_RIGHT, NORMAL);
    }
  }
}


void DrawIcon(BYTE addrH, BYTE addrL, BYTE x, BYTE y, BYTE mode) __critical
{
  BYTE width, height, line, repeat, column, result;
  SerialSetAddr(addrH, addrL);
  
  width = SerialReadPostIncr()/6;
  height = SerialReadPostIncr();
  
  column = 0;
  
  for (column = 0; column < width; column++)
  {
    line = 0;
    while (line < height)
    {
      repeat = 0;
      // While repeat is less than the two MSB's of SerialReadNext() do:

      result = SerialReadPostIncr();

      while ( repeat <= ( (result>>6) & 0x03 ) )
      {
        if (mode == ICON_GREY)
        {
          if ((line +repeat) % 2)
          {
            PaintScanLine((result & 0x3f) & 0x2a, x+column, line + repeat + y);
          }
          else
          {
            PaintScanLine((result & 0x3f) & 0x15, x+column, line + repeat + y);
          }
        }
        else
        {
          PaintScanLine((result & 0x3f), x+column, line + repeat + y);
        }
        repeat++;
      }

      line += repeat;
      
    }
  }

}


void ModifyMenuItem(bool goesUp)
{
  switch (selected_item)
  {
    case ITEM_STOP:
      break;
    case ITEM_SND:
      break;
      
    case ITEM_TTIME:
      if (totaltime[SEC] <= 59)
      {
        if (goesUp)
        {
          if (totaltime[SEC] < 59)
          {
            totaltime[SEC]++;
          }
          else if (totaltime[MIN] < 30)
          {
            totaltime[MIN]++;
            totaltime[SEC] = 0;
          }
        }
        else if (totaltime[SEC] > 0)
        {
          totaltime[SEC]--;
        }
        else if (totaltime[MIN] > 0)
        {
          totaltime[MIN]--;
          totaltime[SEC] = 59;
        }
        // Prints time
        PaintDec(totaltime[MIN], 10, 7, MODE_EXOR);
        PaintDec(totaltime[SEC], 13, 7, MODE_EXOR);
      }
      break;
      
    case ITEM_STIME:
      if ((spottime <= 30) && (spottime >= 1))
      {
        if (goesUp)
        {
          if (spottime < 30)
          {
            spottime++;
          }
        }
        else if (spottime > 1)
        {
          spottime--;
        }
        PaintDec(spottime, 13, 12, MODE_EXOR);
      }
      break;
    case ITEM_POW:
      if (power <= 100)
      {
        if (goesUp)
        {
          if (power < 100)
          {
            power++;
          }
        }
        else if (power > 0)
        {
          power--;
        }
        PaintDec(power, 26, 7, MODE_EXOR);
      }
      break;
    default:
      break;
  }
}


void testEncoder()
{
  status[0] = ENCODER_A + (ENCODER_B*2) + (ENCODER_P*4);
  while (1)
  {
    status[1] = ENCODER_A + (ENCODER_B*2) + (ENCODER_P*4);
    if (status[0] == status[1])
    {
      continue;
    }
    else if ((status[0] & 3) != (status[1] & 3))
    {
      if (selected_item == 255)
      {
        if (goesUp(status[0] & 3, status[1] & 3))
        {
  	      DrawMenuItem(TRUE);
          menu_option++;
          menu_option%=10;
        }
        else
        {
  	      DrawMenuItem(TRUE);
  	      if (menu_option == 0)
  	      {
  	        menu_option=9;
  	      }
  	      else
  	      {
            menu_option--;
            menu_option%=10;
          }
        }
      }
      else
      {
        ModifyMenuItem(goesUp(status[0] & 3, status[1] & 3));
        PrintLineAlignXY("ModifyMenuItem()", 1, 1, ALIGN_LEFT, NORMAL);
      }
    }
    else if ((status[0] & 4) != (status[1] & 4))
    {
      ExecuteMenuItem(status[1]&4);
      PrintLineAlignXY("ExecuteMenuItem()", 1, 1, ALIGN_LEFT, NORMAL);
    }
    status[0] = status[1];
	  PaintHex(menu_option, 1, 10, NORMAL);
	  DrawMenuItem(FALSE);
  }
  
}
