/*
    temete1.c
    Ricardo L. Febrero <rlfebrero@gmail.com>
    
    See COPYING for more details on the license.
    (c) April 2009
    
    Precautions should be taken on using it or you can get burnt!!
*/

#include "temete2.h"
#include "temete3.h"
#include "temete4.h"


volatile BYTE totaltime[]={1,30};
BYTE language=I18N_ES;
BYTE count_down[]={0xff,COUNTER_HIGH};
volatile BYTE interrupt_draw_enable=TRUE;

/* Setup chip configuration */
typedef unsigned int config;
config at 0x2007 __CONFIG = _CP_OFF & 
                          _WDT_OFF & 
                          _BODEN_OFF & 
                          _PWRTE_OFF &
                          _HS_OSC &
                          _LVP_OFF &
                          _WRT_ENABLE_OFF;


static void Pantini(void)
{
  //BYTE i;
  
	PORTD = 0xf0;   /* WR, RD, CE, CMD */
	PORTC = 0x01;   /* FS */
	
	RC5 = 0;        /* Reset */
	
	Pause();
	
	RC5 = 1;         /* Reset off */
	
	PauseLong();
	
	dt2(0,0);
	cmd(TXHOME);    /* Text home address 0x0000 */
	dt2(2,128);
	cmd(GRHOME);    /* Set graphic home address 0x280 */
	dt2(0,0x28);
	cmd(TXAREA);    /* Text area: 40 col 6x8 */
	dt2(0,0x28);
	cmd(GRAREA);    /* Graphic area: 40 col */
	cmd(MODE_EXOR); /* Modeset (XOR mode, internal character gen mode) */
	cmd(DISP_GR_ON_TXT_ON);      // Text on, graphics on
	Borrar();
}


void Menu()
{
  PrintLineAlign("RADIOFREQUENCY SYSTEM", 2, ALIGN_CENTER, NORMAL);
  
  PrintLineAlignXYI18n(I18N_TOTAL_TIME_H, I18N_TOTAL_TIME_L, 16, 5, ALIGN_RIGHT, NORMAL);
  PrintLineAlignXY("01'30\"", 11, 7, ALIGN_RIGHT, MODE_EXOR);
  
  PrintLineAlignXYI18n(I18N_SPOT_TIME_H, I18N_SPOT_TIME_L, 16, 10, ALIGN_RIGHT, NORMAL);
  PrintLineAlignXY("15\"", 11, 12, ALIGN_RIGHT, MODE_EXOR);
  
  PrintLineAlignXYI18n(I18N_POWER_H, I18N_POWER_L, 26, 5, ALIGN_LEFT, NORMAL);
  PrintLineAlignXY("75%", 30, 7, ALIGN_LEFT, MODE_EXOR);

  
  PrintHorizStrike();
  DrawIcons();
}


static void Intr(void) __interrupt 0
{
  
  T0IE = 0;     // Disable the countdown
  
  if (T0IF)
  {
    // Count decrement
    if (count_down[0] > 0)
    {
      count_down[0]--;
    }
    else if (count_down[1] > 0)
    {
      count_down[0]=0xff;
      count_down[1]--;
    }
    else
    {
      count_down[0]=0xff;
      count_down[1]=COUNTER_HIGH;
      
      
      // Time decrement
      if ((totaltime[1] == 1) && (totaltime[0] == 0))
      {
        // The treatment has ended.
        T0IF = 0;
        return;
      }
      
      if (totaltime[1] > 0)
      {
        totaltime[1]--;
      }
      else if (totaltime[0] > 0)
      {
        totaltime[0]--;
        totaltime[1] = 59;
      }
      else
      {
        // The treatment has ended.
        T0IF = 0; 
        return;
      }
      
      if (interrupt_draw_enable)
      {
        PaintDec(totaltime[MIN], 5, 7, MODE_EXOR);
        PaintDec(totaltime[SEC], 8, 7, MODE_EXOR);
      }
      // END Time Decrement
    
      /*
      T0IF = 0;
      T0IE = 1;     // Enable the countdown
      return;
      */
    }
    // END Count decrement
  
    T0IF = 0;
  }
  
  T0IE = 1;     // Enable the countdown
}

static void init_system()
{
    GIE = 1;         /* Enable global interrupts */
    PEIE = 1;        /* Enable peripheral interrupts */

    PS0 = 1;        // option register b'111'
    PS1 = 1;
    PS2 = 1;

    T0CS = 0;    /* Source of timer0 is instruction clock */
    T0SE = 0;    /* Increment timer0 on low-to-high transition */
    PSA = 1;     /* Prescaler assigned to the watchdog */
    TMR0 = 0;                   /* clear timer0 */
}


void main(void) {
    
    /* Assign input/output state to tristates */     
    TRISA = A_OUTPUTS;
    TRISB = B_OUTPUTS;
    TRISC = C_OUTPUTS;
    TRISD = D_OUTPUTS;
    TRISE = E_OUTPUTS;
    /* Initialize ports */
    PORTA=0;
    PORTB=0;
    PORTC=0;
    PORTD=0;
    PORTE=0;
    
    Beep(BEEP_START);
    Pantini();
    init_system();
    Menu();
    
    T1CON = 0x21;
    T2CON = 0x06;
    PR2 = 0xff;
    CCP2CON = 0x0c;
    CCPR2L = 0x30;
    
    /*
    // Timer 2
    PR2=0xff;   // 4 MHz clock -> 5kHz PWM frequency
    T2CON = (1<<TMR2ON);

    // Initialize Control PWM
    CCPR2L  = 30;    // Initial Duty
    CCP2CON = 0x0f;  // PWM mode set and 5,4 duty = 0
    */
    Beep(BEEP_END);
    testEncoder();
    while(1);
}
