/*
    temete4.c
    Ricardo L. Febrero <rlfebrero@gmail.com>
    
    See COPYING for more details on the license.
    (c) April 2009
    
    Precautions should be taken on using it or you can get burnt!!
*/

#include "temete4.h"
#include "temete2.h"

extern BYTE language;
extern BYTE totaltime[2];
extern BYTE count_down[2];

volatile static BYTE paintdec_is_free = TRUE;
volatile static BYTE paintchar_is_free = TRUE;
volatile static BYTE cmd_is_free = TRUE;
volatile static BYTE dt2_is_free = TRUE;
volatile static BYTE dt1_is_free = TRUE;

void PaintScanLine(BYTE pattern, BYTE x, BYTE y)
{
  //BYTE i;
  unsigned int pos;

  pos = (((y-1)*40)+x-1)+640;
  dt2((BYTE)(pos / 256),(BYTE)(pos % 256));
  cmd(ADPSET);
  dt1(pattern);
  cmd(0xc4);
}

#pragma save
#pragma nooverlay

void cmd(volatile BYTE parameter)
{
  
  if (!cmd_is_free)
  {
    return;
  }
  cmd_is_free = FALSE;
  
	WaitReady();
	Save(CMD, parameter);
	
  cmd_is_free = TRUE;
}

#pragma restore

#pragma save
#pragma nooverlay

void dt2(volatile BYTE h, volatile BYTE l)
{
  
  if (!dt2_is_free)
  {
    return;
  }
  dt2_is_free = FALSE;
  
	WaitReady();
	Save(DATA, l);
	WaitReady();
	Save(DATA,h);
	
  dt2_is_free = TRUE;
}

#pragma restore

#pragma save
#pragma nooverlay

void dt1(volatile BYTE inData)
{
  
  if (!dt1_is_free)
  {
    return;
  }
  dt1_is_free = FALSE;
  
	WaitReady();
	Save(DATA, inData);
	
  dt1_is_free = TRUE;
}

#pragma restore

void Save(volatile bool param, volatile BYTE data_) // SALVADATO
{
	RD5 = param;    //
	TRISB = 0;      // Output
	PORTB = data_;  //  
	RD7 = 0;        // WR
	RD6 = 1;        // RD
	RD4 = 0;        // CE
	Pause();
	RD7 = 1;        // WR
}


#pragma save
#pragma nooverlay

void PaintChar(volatile BYTE value, volatile BYTE x, volatile BYTE y,
               volatile BYTE mode)
{
  volatile BYTE hh, ll;
  
  if (!paintchar_is_free)
  {
    return;
  }
  paintchar_is_free = FALSE;
  
  if ((y < 7) || ((y == 7) && (x < 17)))
  {
    hh = 0;
    ll = (y-1)*40+x-1;
  }
  else if ((y < 13) || ((y == 13) && (x < 33)))
  {
    hh = 1;
    ll = 40*(y-7)+x-17;
  }
  else
  {
    hh = 2;
    ll = 40*(y-13)+x-33;
  }

  cmd(mode);
  dt2(hh,ll);
	cmd(ADPSET);
	dt1(value);
	cmd(0xc4);
	
  paintchar_is_free = TRUE;
}

#pragma restore


void PaintHex(BYTE value, BYTE x, BYTE y, BYTE mode)
{
  if ((value%16) < 10)
  {
    PaintChar((value%16)+16, x+1, y, mode);
  }
  else
  {
    PaintChar((value%16)+23, x+1, y, mode);
  }

  value/=16;
  
  if ((value%16) < 10)
  {
    PaintChar((value%16)+16, x, y, mode);
  }
  else
  {
    PaintChar((value%16)+23, x, y, mode);
  }
}


#pragma save
#pragma nooverlay

void PaintDec(volatile BYTE value, volatile BYTE x, volatile BYTE y,
              volatile BYTE mode)
{
  if (!paintdec_is_free)
  {
    return;
  }
  paintdec_is_free = FALSE;
  
  PaintChar((value%10)+16, x+1, y, mode);

  value/=10;
  
  PaintChar((value%10)+16, x, y, mode);
  
  paintdec_is_free = TRUE;
}

#pragma restore


void PauseLong()
{
	unsigned int i;
	for ( i=0; i<=65000; i++ )
	{
	}
}


void PauseQuarterSecond()
{
	BYTE i;
	for ( i=0; i<=2; i++ )
	{
	  PauseLong();
	}
}


void Beep(BYTE mode)
{
  unsigned int i;
  char j;
  BYTE cond;

  TRISA0 = 0;
  cond = 0;
  j = 7;
  while(j >= 0)
  {
    if (mode & (1 << j))    // Long beep
    {
      if (!cond)
      {
        for ( i=0; i<= 65000; i++ );
        cond = 1;
      }
      for ( i=0; i<= 15000; i++ );
      RA0 = 1;
      for ( i=0; i<= 50000; i++ );
      RA0 = 0;
    }
    else if (cond)
    {
      for ( i=0; i<= 15000; i++ );
      RA0 = 1;
      for ( i=0; i<= 10000; i++ );
      RA0 = 0;
    }
    j--;
  }
}


void BeepError(BYTE mode)
{
  Beep(mode);
  while(1);
}


void Pause()
{
	BYTE i;
	for ( i=0; i<=2; i++ )
	{
	}
}


void Sleep(BYTE steps)
{
  BYTE i;
  for (i=0; i<steps; i++)
  {}
}


void WaitReady(void) /* LEER */
{
  //BYTE accum;
  BYTE byte0, byte1;
  
  byte0 = 0;
  byte1 = 0;
  
  while(!(byte0 && byte1))
  {
    RD4 = 1;      /* CE */
    TRISB = 0x03; /* Input */
    RD5 = 1;      /* CMD */
    RD7 = 1;      /* WR */
    RD6 = 0;      /* RD */
    RD4 = 0;      /* CE */
    Pause();      /* Pause */
    byte0 = RB0;
    byte1 = RB1;
    RD6 = 1;      /* RD */
    RD4 = 1;      /* CE */
  }
}


void SerialStart()
{
  Sleep(I2C_SLEEP_ITER);
  TRISC = C_OUTPUTS;
  SDA = 1;
  SCL = 1;
  Sleep(I2C_SLEEP_ITER);
  SDA = 0;
  Sleep(I2C_SLEEP_ITER);
  SCL = 0;
  Sleep(I2C_SLEEP_ITER);
}


void SerialStop()
{
  TRISC = C_OUTPUTS;
  SCL = 0;
  SDA = 0;
  Sleep(I2C_SLEEP_ITER);
  SCL = 1;
  Sleep(I2C_SLEEP_ITER);
  SDA = 1;
  Sleep(I2C_SLEEP_ITER);
}


void SerialByteSend(BYTE outData)
{
  unsigned int i;
  
  TRISC = C_OUTPUTS;

  SDA = 0;
  
  for (i=0; i<8; i++)
  {
    if (outData & (128>>i))
    {
      SDA = 1;
    }
    else
    {
      SDA = 0;
    }
    Sleep(I2C_SLEEP_ITER);
    SCL = 1;
    Sleep(I2C_SLEEP_ITER_LONG);
    SCL = 0;
    //outData = outData << 1;
    Sleep(I2C_SLEEP_ITER);
  }
  
  SDA = 0;
  TRISC = 0x04 | C_OUTPUTS;
  Sleep(I2C_SLEEP_ITER);
  SCL = 1;
  Sleep(I2C_SLEEP_ITER_LONG);
  SCL = 0;
  Sleep(I2C_SLEEP_ITER);
}



BYTE SerialByteRecv()
{
  BYTE inData = 0x00;
  BYTE i;
  
  TRISC = 0x04 | C_OUTPUTS;

  
  for (i=0; i<8; i++)
  {
    inData<<=1;
    Sleep(I2C_SLEEP_ITER);
    SCL = 1;
    Sleep(I2C_SLEEP_ITER);
    if (SDA)
    {
      inData ++;
    }
    Sleep(I2C_SLEEP_ITER);
    SCL = 0;
    Sleep(I2C_SLEEP_ITER);
  }

  Sleep(I2C_SLEEP_ITER);
  TRISC = C_OUTPUTS;
  SDA = 1;
  Sleep(I2C_SLEEP_ITER);
  SCL = 1;
  Sleep(I2C_SLEEP_ITER_LONG);
  SCL = 0;
  Sleep(I2C_SLEEP_ITER);
  SDA = 0;
  
  
  return inData;
}


BYTE SerialRead(BYTE addrH, BYTE addrL)
{
  BYTE answer;
  
  SerialStart();
  
  Sleep(I2C_SLEEP_ITER);
  SerialByteSend(0xa0);
  Sleep(I2C_SLEEP_ITER);
  SerialByteSend(addrH);
  Sleep(I2C_SLEEP_ITER);
  SerialByteSend(addrL);
  Sleep(I2C_SLEEP_ITER);
  SerialStart();
  Sleep(I2C_SLEEP_ITER);
  
  SerialByteSend(0xa1);
  Sleep(I2C_SLEEP_ITER);
  
  answer = SerialByteRecv();
  Sleep(I2C_SLEEP_ITER);
  SerialStop();
  Sleep(I2C_SLEEP_ITER);
    
  return answer;
}


void SerialSetAddr(BYTE high, BYTE low)
{
  addressH = high;
  addressL = low;
}


BYTE SerialReadPostIncr()
{
  BYTE result;
  
  result = SerialRead(addressH, addressL);
  
  if (addressL != 255)
  {
    addressL++;
  }
  else
  {
    addressH++;
    addressL = 0;
  }
  
  return result;
}


BYTE SerialReadPostDecr()
{
  BYTE result;
  
  result = SerialRead(addressH, addressL);
  
  if (addressL != 0)
  {
    addressL--;
  }
  else
  {
    addressH--;
    addressL = 255;
  }
  
  return result;
}


void Borrar()
{
  unsigned int hh,ll;
	dt2(0,0);
	cmd(ADPSET);
	cmd(AWRON);
  for (ll=0; ll<=255; ll++)
  {
    for (hh=0; hh<=45; hh++)
	    dt1(0x0);               // 0x0: ' '
  }
	cmd(AWROFF);
}


void Paint(BYTE pattern[8], BYTE x, BYTE y)
{
  BYTE i;
  unsigned int pos;

  pos = (((y-1)*40*8)+x-1)+640;
  for (i=0; i<8; i++)
  {
    dt2((BYTE)(pos / 256),(BYTE)(pos % 256));
    cmd(ADPSET);
    dt1(pattern[i]);
    cmd(0xc4);
    pos = pos + 40;
  }
}


bool CountDecrement()
{
  if (count_down[0] > 0)
  {
    count_down[0]--;
  }
  else if (count_down[1] > 0)
  {
    count_down[1]--;
    count_down[0]=0xff;
  }
  else
  {
    CountReset();
    return FALSE;
  }
  return TRUE;
}


void CountReset()
{
  count_down[0]=0xff;
  count_down[1]=COUNTER_HIGH;
}
