/*
    temete4.h
    Ricardo L. Febrero <rlfebrero@gmail.com>
    
    See COPYING for more details on the license.
    (c) April 2009
    
    Precautions should be taken on using it or you can get burnt!!
*/

/* Define processor and include header file. */
#ifndef TEMETE4_H
#define TEMETE4_H


#define A_OUTPUTS   0x06    /* value used to setup TRISA */
#define B_OUTPUTS   0x00    /* value used to setup TRISB */
#define C_OUTPUTS   0x40    /* value used to setup TRISC */
#define D_OUTPUTS   0x0c    /* value used to setup TRISD */
#define E_OUTPUTS   0x00    /* value used to setup TRISE */

#define TXHOME			0x40
#define TXAREA			0x41
#define GRHOME			0x42
#define GRAREA			0x43
#define OFFSET			0x22
#define ADPSET			0x24
#define AWRON				0xB0
#define AWROFF			0xB2
#define CMDP				0x01
#define DP					0x00

#define I2C_SLEEP_ITER 2
#define I2C_SLEEP_ITER_LONG 5

#define DISP_GR_ON_TXT_ON 0x9c

#define MODE_OR     0x80
#define MODE_EXOR   0x81
#define MODE_AND    0x82

#define ICON_NORMAL 0
#define ICON_GREY   1

#define ALIGN_LEFT   0
#define ALIGN_RIGHT  1
#define ALIGN_CENTER 2

#define BEEP_START        1
#define BEEP_END          2
#define ERROR_LINEEND     3
#define ERROR_TEXTLENGTH  4
#define ERROR_TEXTPOS     5
#define ERROR_LOGO        6


#define ADDR_BODY_H 0
#define ADDR_BODY_L 0

#define ADDR_FACE_H 0
#define ADDR_FACE_L 0x22

#define ADDR_LANGEN_H 0
#define ADDR_LANGEN_L 0x47

#define ADDR_LANGES_H 0
#define ADDR_LANGES_L 0x6b

#define ADDR_LANGFR_H 0
#define ADDR_LANGFR_L 0x90

#define ADDR_PLAY_H 0
#define ADDR_PLAY_L 0xb4

#define ADDR_SOUNDOFF_H 0
#define ADDR_SOUNDOFF_L 0xd4

#define ADDR_SOUNDON_H 0
#define ADDR_SOUNDON_L 0xf1

#define ADDR_STOP_H 1
#define ADDR_STOP_L 0x16

#define ADDR_TRANSFER_H 1
#define ADDR_TRANSFER_L 0x33


// I18n =>

#define I18N_ES 0
#define I18N_EN 1
#define I18N_FR 2

#define I18N_TOTAL_TIME_L 0x59
#define I18N_TOTAL_TIME_H 0x01
#define I18N_POWER_L      0x80
#define I18N_POWER_H      0x01
#define I18N_SPOT_TIME_L  0x9e
#define I18N_SPOT_TIME_H  0x01

// <= I18n


#define DATA				FALSE
#define	CMD					TRUE

// Serial I2C Memory pins
#define SDA RC2
#define SCL RC3

// Encoder pins
#define ENCODER_A RD3
#define ENCODER_B RC6
#define ENCODER_P RD2

// Timer
#define COUNTER_HIGH 0x80


#define __16f877
#include "pic/pic16f877.h"

typedef enum t_menuitem { ITEM_STOP, ITEM_START, ITEM_LANG, ITEM_SND,
                          ITEM_BODY, ITEM_FACE, ITEM_TRANSF, ITEM_TTIME,
                          ITEM_STIME, ITEM_POW } TMenuItem;
typedef enum t_treatment{TREAT_BODY, TREAT_FACE, TREAT_TRANS} TTreatment;

typedef enum { FALSE, TRUE } bool;
typedef enum t_style{NORMAL, INVERTED} TStyle;

typedef unsigned char BYTE;

static BYTE addressH=0;
static BYTE addressL=0;
static BYTE status[]={0,0};
static TMenuItem menu_option=0;
static TMenuItem selected_item=255;

static TTreatment treatment=TREAT_BODY;
static BYTE power=75;
static BYTE spottime=15;
static bool sound=FALSE;

#define MIN 0
#define SEC 1

void PaintScanLine(BYTE pattern, BYTE x, BYTE y);

void cmd(BYTE parameter);
void Save(bool param, BYTE data_);
void dt2(BYTE h, BYTE l);
void dt1(BYTE inData);

void PaintChar(BYTE value, BYTE x, BYTE y, BYTE mode);
void PaintHex(BYTE value, BYTE x, BYTE y, BYTE mode);
void PaintDec(BYTE value, BYTE x, BYTE y, BYTE mode);

void PauseLong();
void PauseQuarterSecond();
void Beep(BYTE mode);
void BeepError(BYTE mode);
void Pause();
void Sleep(BYTE steps);
void WaitReady(void); /* LEER */

void SerialStart();
void SerialStop();
void SerialByteSend(BYTE data);
BYTE SerialByteRecv();
BYTE SerialRead(BYTE addrH, BYTE addrL);

void SerialSetAddr(BYTE high, BYTE low);
BYTE SerialReadPostIncr();
BYTE SerialReadPostDecr();
BYTE SerialReadCurrent();

void Borrar();
void Paint(BYTE pattern[8], BYTE x, BYTE y);

bool CountDecrement();
void CountReset();

#endif
