import org.apache.avalon.framework.component.ComponentManager;
import java.text.DateFormat;

import java.sql.*;
import java.io.*;
import java.util.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import javax.xml.parsers.*;

/**
* Class reads application.xconf XML file 
* and collecs information on the documentbases declared in an application
**/

public class CocoonConfReader
{

private Vector dsi;

private Vector dburl;
private Vector user; 
private Vector password;


public CocoonConfReader (String Path)

    {
    dsi = new Vector();
    dburl =  new Vector();
    user = new Vector();
    password = new Vector();

    readConfig(Path);
    }


public class CXconfFileHandler extends DefaultHandler {


private String fieldcontent;
private String fieldvalue;
private String dsiname;
private boolean record = false;

private StringBuffer fb;

public CXconfFileHandler()
    {
    super();
    }


public void startElement(String namespace,
                         String localName,
                         String qName,
                         Attributes atts)
{
try {

    if (localName.equals("jdbc")) {
        dsiname = atts.getValue("name");
	dsi.addElement(dsiname); 
        }
    else if (localName.equals("dburl")) {
        fb = new StringBuffer();
	record = true;
        }
    else if (localName.equals("user")) {
        fb = new StringBuffer();
	record = true;
        }
    else if (localName.equals("password")) {
        fb = new StringBuffer();
	record = true;
        }

    return;
    }
catch (Exception e) {
        e.printStackTrace();
        }
}

public void characters(char[] ch,
                       int start,
                       int length)
{
try
    {
    if (!record) return; 

    String content = new String(ch);

    String fieldcontent = content.substring(start,start + length);

    fb.append(fieldcontent);

    return;
    }
catch (Exception e) {
        e.printStackTrace();
        }

}


public void endElement(String uri,
                       String localName,
                       String qName) throws SAXException
{
try
    {
    if (localName.equals("dburl")) {
	dburl.addElement(fb.toString());
	record = false; 
	}
    else if (localName.equals("user")) {
	user.addElement(fb.toString());
	record = false; 
	}
    else if (localName.equals("password")) {
	password.addElement(fb.toString());
	record = false; 
	}
    }
catch (Exception e) {
    e.printStackTrace();
    }
}


}

public boolean readConfig(String Path)
    {
try {
    SAXParserFactory spf = SAXParserFactory.newInstance();
    SAXParser sp = spf.newSAXParser();
    ParserAdapter pa = new ParserAdapter(sp.getParser());

    CXconfFileHandler W = new CXconfFileHandler();
    pa.setContentHandler(W);
    pa.parse(Path);

    return true;

    }
catch (IOException ex) {
    System.out.println("ERROR: " + ex.getMessage());
    return false;
    }
catch (Exception e) {
    System.out.println("ERROR: " + e.getMessage());
    e.printStackTrace();
    return false;
    }

    }

public Connection getConnection(String dsiname)
{
int p = dsi.indexOf(dsiname); 
if (p == -1) return null;
String url = (String) dburl.elementAt(p);
String usr = (String) user.elementAt(p);
String pwd = (String) password.elementAt(p);
Connection conn = null;

        try
        {
             Class.forName("org.gjt.mm.mysql.Driver");
        }
        catch (java.lang.ClassNotFoundException e)
        {
            System.err.println(e.toString());
            e.printStackTrace();
            return null;
        }


        try
        {
            conn = DriverManager.getConnection(url, usr, pwd);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            System.err.println(e.toString());
            e.printStackTrace();
        }


    return conn;
}


}

 
