
public class InventarisSanityCheck {

public static void main(String[] args)
{
try {

    if (args.length == 0) {
	System.out.println("Usage: java InventarisSanityCheck [configdir] [--base={documentbase}] [--cocoon={path2cocoon.xconf}] [--repair={true|false}]");
	return;
	}

    boolean repair = false;
    String sdxconfdir = args[0];
    String indexname = null;
    String cocoonconfpath = null;

    for (int j=1; j<args.length;j++) {
	if (args[j].indexOf("--base") == 0) {
		indexname = args[j].substring(7,args[j].length());
		System.out.println("Investigating " + indexname);
		}
	else if (args[j].indexOf("--cocoon") == 0) {
		cocoonconfpath = args[j].substring(9,args[j].length());
		System.out.println("path to cocoon: " + cocoonconfpath);
		}
	else if (args[j].indexOf("--repair") == 0) {
		String repstring = args[j].substring(9,args[j].length());
		repair = repstring.equals("true");
		}
	}

    if (repair) System.out.println("Attention ! Repair option is on. Documents will be deleted from the repository ");
	
    SDXHealthChecker SDX = new SDXHealthChecker(sdxconfdir,indexname,cocoonconfpath,repair);
/*
    SDX.trackLuceneIndex();

    SDX.trackHSQL();
*/
    SDX.traceOrphanisedRepositoryDocs();
    System.exit(0);
    } 
catch (Exception e) {
    e.printStackTrace();
    }
}

}
