import org.apache.avalon.framework.component.ComponentManager;
import java.text.DateFormat;

import java.sql.*;
import java.io.*;
import java.util.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import javax.xml.parsers.*;

/**
* Class reads application.xconf XML file 
* and collecs information on the documentbases declared in an application
**/

public class SdxConfReader
{
private String applicationId = "";
private String applicationname = "";

private Vector bases;
private Vector basetypes;

private Hashtable repobybase;

private Vector repositories;
private Vector repotypes; 
private Vector repository_dsi;

private String currentbase = "";

public SdxConfReader (String Path)

    {
    bases = new Vector();
    basetypes = new Vector();
    repobybase = new Hashtable();
    repositories = new Vector();
    repotypes = new Vector();
    repository_dsi = new Vector();

    readConfig(Path);
    }


public class XconfFileHandler extends DefaultHandler {


private String fieldcontent;
private String fieldvalue;

private StringBuffer fb;

public XconfFileHandler()
    {
    super();
    }


public void startElement(String namespace,
                         String localName,
                         String qName,
                         Attributes atts)
{
try {
    if (localName.equals("documentBase")) {
        fb = new StringBuffer();
	currentbase = atts.getValue("id");
	System.out.println("found base " + currentbase);
	bases.addElement(currentbase);
        }
    else if (localName.equals("repository")) {
        String repo = atts.getValue("id");
	repositories.addElement(repo);
	// current assumption: one repository for each base
	repobybase.put(currentbase, repo);
	String repotype = atts.getValue("type");
	repotypes.addElement(repotype);
	if (repotype.equals("JDBC")) {
		repository_dsi.addElement(atts.getValue("dsi"));
		}
	else if (repotype.equals("FS")) {
		repository_dsi.addElement(atts.getValue("baseDirectory"));
		}
	else repository_dsi.addElement("");
        }
    else if (localName.equals("application")) {
	applicationId = atts.getValue("id");
	int pos = applicationId.lastIndexOf(".");
	applicationname = applicationId.substring(pos+1,applicationId.length());
	System.out.println("applicationname = " + applicationname);
	}

    return;
    }
catch (Exception e) {
        e.printStackTrace();
        }
}

public void characters(char[] ch,
                       int start,
                       int length)
{
try
    {
    // at this moment we record nothing
    if (true) return; 

    String content = new String(ch);

    String fieldcontent = content.substring(start,start + length);

    fb.append(fieldcontent);

    return;
    }
catch (Exception e) {
        e.printStackTrace();
        }

}


public void endElement(String uri,
                       String localName,
                       String qName) throws SAXException
{
try
    {

    }
catch (Exception e) {
    e.printStackTrace();
    }
}


}

public boolean readConfig(String Path)
    {
try {
    SAXParserFactory spf = SAXParserFactory.newInstance();
    SAXParser sp = spf.newSAXParser();
    ParserAdapter pa = new ParserAdapter(sp.getParser());

    XconfFileHandler W = new XconfFileHandler();
    pa.setContentHandler(W);
    pa.parse(Path);

    return true;

    }
catch (IOException ex) {
    System.out.println("ERROR: " + ex.getMessage());
    return false;
    }
catch (Exception e) {
    System.out.println("ERROR: " + e.getMessage());
    e.printStackTrace();
    return false;
    }

    }

public String getRepository(String base)
    {
    String val = (String) repobybase.get(base);
    return val;
    }

public String getDsi(String repo)
    {
    int ind = repositories.indexOf(repo);
    if (ind == -1) return null;
    return (String) repository_dsi.elementAt(ind);
    }

public Vector getBases()
    {
    return bases;
    }

public String getName()
    {
    return applicationname;
    }

public String getId()
    {
    return applicationId;
    }

public boolean isJdbc(String repo)
    {
    int ind = repositories.indexOf(repo);
    if (ind == -1) return false;
    String tt = (String) repotypes.elementAt(ind);
    if (tt.equals("JDBC")) return true;
    return false;
    }

public static int indexOf(String [] haystack, String needle)
{
if (needle == null) return -1;
if (haystack == null) return -1;
for (int j=0; j < haystack.length; j++) {
        if (needle.equals(haystack[j])) return j;
        }
return -1;
}


}

 
