import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.WildcardTermEnum; 

public class analyzeTerms {

public static void main(String[] args)
{
try {

    if (args.length == 0) {
	System.out.println("Usage: java analyzeTerms configdir field base");
	return;
	}

    boolean repair = false;
    String sdxconfdir = args[0];
    String field = args[1];
    String base = args[2];

    IndexReader ir = IndexReader.open(sdxconfdir + "/dbs/" + base + "/sdx-search-index");
    Term universe = new Term(field,"*");
    WildcardTermEnum W = new WildcardTermEnum(ir, universe);

    System.out.println("term | frequentie in inventaris");
    while (W.next()) {
	Term t = W.term();
	int f = W.docFreq();
	System.out.println(t.text()+"|" + f);
	}
    }
catch (Exception e) {
    e.printStackTrace();
    }
}

}
