import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.WildcardTermEnum; 
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

import java.sql.*;

public class emptyDocumentBase {

public static final String PROTOCOL_PREFIX = "jdbc:hsqldb:";
public static final String CLASS_NAME_SUFFIX = "HSQLDB";
public static final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";

private static Connection hSQLconnection = null;


public static void main(String[] args)
{
try {

    if (args.length == 0) {
	System.out.println("Usage: java emptyDocumentBase configdir base");
	return;
	}

    String sdxconfdir = args[0];
    String base = args[1];

    System.out.println("getting connection to HSQL");
    hSQLconnection = getHSQLConnection(sdxconfdir);
    System.out.println("got connection to HSQL");

    // preparing counting 
    // PreparedStatement ps1 = hSQLconnection.prepareStatement("select count(*) from " + base);
    PreparedStatement ps1 = hSQLconnection.prepareStatement("drop table " + base);
    ResultSet rsc = ps1.executeQuery();
    int count = 0;
    if (rsc.next()) count = rsc.getInt(1);
    System.out.println("er zijn nog " + count + " records ");
    PreparedStatement ps = hSQLconnection.prepareStatement("delete from " + base);
    ps.executeUpdate();
    System.out.println("deleted " + count + " records ");

    System.out.println("opening indexreader ");
    IndexReader ir = IndexReader.open(sdxconfdir + "/dbs/" + base + "/sdx-search-index");

    IndexWriter writer = new IndexWriter(sdxconfdir + "/dbs/" + base + "/sdx-search-index", new StandardAnalyzer(), false);
    Term universe = new Term("sdxdocid","*");
    WildcardTermEnum W = new WildcardTermEnum(ir, universe);

    while (W.next()) {
        Term t = W.term();
	ir.delete(t);
        }

    writer.close();
    }
catch (Exception e) {
    e.printStackTrace();
    }
}

static Connection getHSQLConnection(String dbDirPath)

{
try {
    Class.forName(HSQLDB_DRIVER);
    Connection conn = DriverManager.getConnection(PROTOCOL_PREFIX + dbDirPath + "/databases/_hsql/", // filenames
            "sa", // username
            "");                     // password
    return conn;
    }
catch (Exception e) {
    e.printStackTrace();
    }
return null;
}




}
