import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.queryParser.QueryParser;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.xml.sax.Attributes;
import javax.xml.parsers.*;

import java.io.*;
import java.util.*;


public class testRead {


public static void main(String[] args)
{
try {

  String indexname = args[0];

  IndexSearcher is = new IndexSearcher(indexname + "/sdx-search-index");
  Analyzer analyzer = new StandardAnalyzer();
  QueryParser parser = new QueryParser("article", analyzer);
  Query query = parser.parse("sdxall:1");
  Hits hits = is.search(query);

  String docid = "";
  int runlength = 0;

  // looping over the hits (all documents)
    for (int i=0; i<hits.length(); i++) {
	Document doc = hits.doc(i);

	String sdxdocid = doc.get("sdxdocid");
	if (sdxdocid == null) {
		System.out.println("NIET NORMAAL ! sdxdocid zou null zijn");
     		dumpLuceneDoc(doc);
		} 
	else {
	    if (sdxdocid.equals("80634")) {
			System.out.println("80634 gevonden in positie " + i);
			dumpLuceneDoc(doc);
			}
	    if (docid.equals(sdxdocid)) runlength++;
	    else {
		docid = sdxdocid;
		runlength = 0;
		}
	    }
      if (runlength > 0) {
		System.out.println("Multiple indexering van document " + sdxdocid + ", " + runlength + " dubbels... ");
		}
      }
    is.close();
    }
catch (Exception e) {
    e.printStackTrace();
    }
}

static void dumpLuceneDoc(Document doc) 
{
try {

      System.out.println("============== DOCUMENT DUMP ==============");
      Enumeration E = doc.fields();
      while (E.hasMoreElements()) {
        Field ff = (Field) E.nextElement();
	System.out.println("Field " + ff.name() + " = " + ff.stringValue());
	} 
      System.out.println("==============          ==============");
    }
catch (Exception e) {
    e.printStackTrace();
    }
}

}
