package org.apache.james.smtpserver;

import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

import javax.mail.internet.MimeMessage;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

/** Holds SMTP state for SMTPACL Matchers.
 *
 * @author Alexander Zhukov <zhukov@ukrpost.net>
 */
public class SMTPACLMail implements Mail {
    private SMTPState state = null;
    public SMTPACLMail(SMTPState state) {
        this.state = state;
        System.out.println("constructing aclmail from smtpstate: "+state);
        setName("aclmailfrom_"+String.valueOf(state.getRemoteHost()));
    }

    public Collection getRecipients() {
        return state.getRecipientList();
    }

    public void setRecipients(Collection recipients) {
        System.out.println("acl setrecipients");
    }

    public MailAddress getSender() {
        return state.getSender();
    }

    public String getState() {
        System.out.println("acl getstate");
        return null;
    }

    public String getRemoteHost() {
        return state.getRemoteHost().getHostName();
    }

    public String getRemoteAddr() {
        return state.getRemoteHost().getHostAddress();
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private String errorMessage = "dummy error message";

    public MimeMessage getMessage() {
        return message;
    }

    public void setMessage(MimeMessage message) {
        this.message = message;
    }

    private MimeMessage message = null;

    public void setState(String state) {
        System.out.println("acl setstate "+state);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String name = null;

    public Date getLastUpdated() {
        return lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    private Date lastUpdated = new Date();


    public Serializable getAttribute(String name) {
        return null;
    }

    public Iterator getAttributeNames() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public Serializable removeAttribute(String name) {
        return null;
    }

    public void removeAllAttributes() {
    }

    public Serializable setAttribute(String name, Serializable object) {
        return null;
    }
}
